/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.configuration;

import io.rainfall.Configuration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrencyConfig
extends Configuration {
    private int nbThreads = 1;
    private final Map<Integer, AtomicLong> nbIterationsPerThread = new HashMap<Integer, AtomicLong>();
    private long timeoutInSeconds = 600L;

    public static ConcurrencyConfig concurrencyConfig() {
        return new ConcurrencyConfig();
    }

    public ConcurrencyConfig threads(int nbThreads) {
        this.nbThreads = nbThreads;
        return this;
    }

    public ConcurrencyConfig timeout(int nb, TimeUnit unit) {
        this.timeoutInSeconds = unit.toSeconds(nb);
        return this;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public long getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNbIterationsForThread(int threadNb, long nbIterations) {
        Map<Integer, AtomicLong> map = this.nbIterationsPerThread;
        synchronized (map) {
            if (this.nbIterationsPerThread.size() == 0) {
                int i;
                for (int i2 = 0; i2 < this.nbThreads; ++i2) {
                    this.nbIterationsPerThread.put(i2, new AtomicLong());
                }
                long roundedValue = new Double(Math.floor(nbIterations / (long)this.nbThreads)).longValue();
                for (i = 0; i < this.nbThreads; ++i) {
                    this.nbIterationsPerThread.get(i).addAndGet(roundedValue);
                    nbIterations -= roundedValue;
                }
                i = 0;
                while (nbIterations > 0L) {
                    this.nbIterationsPerThread.get(i % this.nbThreads).incrementAndGet();
                    ++i;
                    --nbIterations;
                }
            }
        }
        return this.nbIterationsPerThread.get(threadNb).longValue();
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList("Threadpool size : " + this.nbThreads);
    }
}

