/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.generator;

import io.rainfall.SequenceGenerator;
import io.rainfall.generator.sequence.Distribution;
import io.rainfall.utils.ConcurrentPseudoRandom;

public class RandomSequenceGenerator
implements SequenceGenerator {
    private final Distribution distribution;
    private final long minimum;
    private final long maximum;
    private final long width;
    private final ConcurrentPseudoRandom rnd = new ConcurrentPseudoRandom();

    public RandomSequenceGenerator(Distribution distribution, long min, long max, long width) {
        this.distribution = distribution;
        this.minimum = min;
        this.maximum = max;
        this.width = width;
    }

    @Override
    public long next() {
        return this.distribution.generate(this.rnd, this.minimum, this.maximum, this.width);
    }

    @Override
    public String getDescription() {
        return "Random sequence with " + this.distribution.getDescription() + " distribution. (min = " + this.minimum + ", max = " + this.maximum + ", width = " + this.width + ")";
    }
}

