/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class RainfallHistogramSink<E extends Enum<E>> {
    private final Factory factory;
    private final ConcurrentLinkedQueue<HistogramHolder> actives = new ConcurrentLinkedQueue();
    private static final ThreadLocal<HistogramHolder> context = new ThreadLocal();

    public RainfallHistogramSink(Factory factory) {
        this.factory = factory;
    }

    private HistogramHolder perThread() {
        HistogramHolder hh = context.get();
        if (hh == null || hh.isDead()) {
            hh = new HistogramHolder(this.factory.createHistograms());
            this.actives.add(hh);
            context.set(hh);
        }
        return hh;
    }

    public void recordValueWithExpectedInterval(Enum<E> result, long value, long expectedIntervalBetweenValueSamples) {
        this.perThread().getHistogram(result).recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithCount(Enum<E> result, long value, long count) {
        this.perThread().getHistogram(result).recordValueWithCount(value, count);
    }

    public void recordValue(Enum result, long value) {
        this.perThread().getHistogram(result).recordValue(value);
    }

    public Histogram fetchHistogram(Enum<E> result) {
        ConcurrentHashMap<Enum, Histogram> aggregate = this.factory.createHistograms();
        for (HistogramHolder hh : this.actives) {
            aggregate.get(result).add((AbstractHistogram)hh.getHistogram(result));
        }
        return aggregate.get(result);
    }

    public synchronized void reset() {
        for (HistogramHolder hh : this.actives) {
            hh.setDead(true);
            Collection<Histogram> histograms = hh.getHistograms();
            for (Histogram histogram : histograms) {
                histogram.reset();
            }
        }
        this.actives.clear();
    }

    public static interface Factory {
        public ConcurrentHashMap<Enum, Histogram> createHistograms();
    }

    private static class HistogramHolder {
        private volatile boolean dead = false;
        private ConcurrentHashMap<Enum, Histogram> histogram;

        public HistogramHolder(ConcurrentHashMap<Enum, Histogram> histogram) {
            this.setHistogram(histogram);
        }

        public boolean isDead() {
            return this.dead;
        }

        public void setDead(boolean dead) {
            this.dead = dead;
        }

        public Histogram getHistogram(Enum result) {
            return this.histogram.get(result);
        }

        public Collection<Histogram> getHistograms() {
            return this.histogram.values();
        }

        public void setHistogram(ConcurrentHashMap<Enum, Histogram> histogram) {
            this.histogram = histogram;
        }
    }
}

