/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics;

import io.rainfall.statistics.RainfallHistogramSink;
import io.rainfall.statistics.Statistics;
import io.rainfall.statistics.StatisticsHolder;
import io.rainfall.statistics.StatisticsPeekHolder;
import io.rainfall.statistics.collector.StatisticsCollector;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jsr166e.LongAdder;
import org.HdrHistogram.Histogram;

public class RuntimeStatisticsHolder<E extends Enum<E>>
implements StatisticsHolder<E> {
    private final ConcurrentHashMap<String, LongAdder> assertionsErrors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Statistics<E>> statistics = new ConcurrentHashMap();
    private final RainfallHistogramSink<E> histograms;
    private final Set<StatisticsCollector> statisticsCollectors;
    private Enum<E>[] results;
    private Enum<E>[] resultsReported;

    public RuntimeStatisticsHolder(final Enum<E>[] results, Enum<E>[] resultsReported, Set<StatisticsCollector> statisticsCollectors) {
        this.results = results;
        this.resultsReported = resultsReported;
        this.statisticsCollectors = statisticsCollectors;
        this.histograms = new RainfallHistogramSink(new RainfallHistogramSink.Factory(){

            @Override
            public ConcurrentHashMap<Enum, Histogram> createHistograms() {
                ConcurrentHashMap<Enum, Histogram> histograms = new ConcurrentHashMap<Enum, Histogram>();
                for (Enum result : results) {
                    histograms.put(result, new Histogram(3));
                }
                return histograms;
            }
        });
    }

    public Enum<E>[] getResults() {
        return this.results;
    }

    @Override
    public Enum<E>[] getResultsReported() {
        return this.resultsReported;
    }

    @Override
    public Set<String> getStatisticsKeys() {
        return this.statistics.keySet();
    }

    @Override
    public Statistics<E> getStatistics(String name) {
        return this.statistics.get(name);
    }

    @Override
    public Set<StatisticsCollector> getStatisticsCollectors() {
        return this.statisticsCollectors;
    }

    @Override
    public Histogram fetchHistogram(Enum<E> result) {
        return this.histograms.fetchHistogram(result);
    }

    public void addStatistics(String name, Statistics<E> statistics) {
        this.statistics.put(name, statistics);
        this.assertionsErrors.put(name, new LongAdder());
    }

    protected long getTimeInNs() {
        return System.nanoTime();
    }

    @Override
    public synchronized void reset() {
        for (Statistics<E> statistics : this.statistics.values()) {
            statistics.reset();
        }
        this.histograms.reset();
    }

    @Override
    public synchronized long getCurrentTps(Enum result) {
        long totalCounter = 0L;
        for (Statistics<E> statistics : this.statistics.values()) {
            totalCounter += statistics.getCurrentTps(result);
        }
        return totalCounter / (long)this.statistics.size();
    }

    @Override
    public void record(String name, long responseTimeInNs, Enum result) {
        this.statistics.get(name).increaseCounterAndSetLatencyInNs(result, responseTimeInNs);
        this.histograms.recordValue(result, responseTimeInNs);
    }

    @Override
    public void increaseAssertionsErrorsCount(String name) {
        this.assertionsErrors.get(name).increment();
    }

    public StatisticsPeekHolder<E> peek() {
        return new StatisticsPeekHolder<E>(this.resultsReported, this.statistics, this.statisticsCollectors, this.assertionsErrors);
    }
}

