/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics.monitor;

import io.rainfall.reporting.HtmlReporter;
import io.rainfall.statistics.collector.StatisticsCollector;
import io.rainfall.statistics.exporter.Exporter;
import io.rainfall.statistics.exporter.HtmlExporter;
import io.rainfall.statistics.exporter.TextExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

public class MemStatisticsCollector
implements StatisticsCollector {
    private static final MemoryMXBean MEM_BEAN = ManagementFactory.getMemoryMXBean();
    private static final String MEM_STATS = "Memory Utilization";
    private Writer memOutput;

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public Exporter peek() {
        return new MemStatisticsExporter(System.currentTimeMillis(), MEM_BEAN.getHeapMemoryUsage().getUsed());
    }

    @Override
    public String getName() {
        return MEM_STATS;
    }

    public class MemStatisticsExporter
    implements HtmlExporter,
    TextExporter {
        private HtmlReporter reporterUtils = new HtmlReporter();
        private String memFile = "memory.csv";
        long timestamp;
        long memoryUsage;

        public MemStatisticsExporter(long timestamp, long memoryUsage) {
            this.timestamp = timestamp;
            this.memoryUsage = memoryUsage;
        }

        @Override
        public void ouputText() {
        }

        @Override
        public void ouputCsv(String basedir) throws Exception {
            String memFilename = basedir + File.separatorChar + this.memFile;
            MemStatisticsCollector.this.memOutput = new BufferedWriter(new FileWriter(memFilename, true));
            if (new File(memFilename).length() == 0L) {
                this.reporterUtils.addHeader(MemStatisticsCollector.this.memOutput, Header.values());
            }
            MemStatisticsCollector.this.memOutput.append(this.reporterUtils.formatTimestampInNano(this.timestamp) + "," + this.memoryUsage);
            MemStatisticsCollector.this.memOutput.close();
        }

        @Override
        public String outputHtml() {
            return "    function reportMemory(filename, title) {\n        $(\"#memory-box\").append(\"<div id='\" + filename + 'memory' + \"' style='height: 550px;width: 1200px;'><div class='title'/><div class='graph'/></div>\");\n        d3.csv(filename + \".csv\", function (data) { processData(data, filename + 'memory', title, 'Memory Utilization') });\n    }\n\n$('body').append('<div class=\"border\"><h1><a name=\"memory\">Memory Utilization</a></h1><div id=\"memory-box\"></div></div><br/>');\nreportMemory('memory', 'Memory Utilization');\n";
        }
    }

    public static enum Header {
        MEMORY_UTILIZATION;

    }
}

