/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.statistics.monitor;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public class PerformanceMonitor {
    private int availableProcessors = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    private long lastSystemTime = 0L;
    private long lastProcessCpuTime = 0L;

    public synchronized double getCpuUsage() {
        if (this.lastSystemTime == 0L) {
            this.baselineCounters();
            return 0.0;
        }
        long systemTime = System.nanoTime();
        long processCpuTime = 0L;
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            processCpuTime = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuTime();
        }
        double cpuUsage = (double)(processCpuTime - this.lastProcessCpuTime) / (double)(systemTime - this.lastSystemTime);
        this.lastSystemTime = systemTime;
        this.lastProcessCpuTime = processCpuTime;
        return cpuUsage / (double)this.availableProcessors;
    }

    private void baselineCounters() {
        this.lastSystemTime = System.nanoTime();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            this.lastProcessCpuTime = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuTime();
        }
    }

    public long getMemoryUsage() {
        long physicalMemorySize = -1L;
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            physicalMemorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreePhysicalMemorySize();
        }
        return physicalMemorySize;
    }

    public String printGCStats() {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        return "Total Garbage Collections: " + totalGarbageCollections + "\n" + "Total Garbage Collection Time (ms): " + garbageCollectionTime + "\n";
    }
}

