/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.utils;

import io.rainfall.TestException;
import io.rainfall.utils.MergeableBitSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainfallServerConnection
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String currentSessionId;
    private int clientId;
    private InetSocketAddress socketAddress;
    private AtomicReference<TestException> testException = new AtomicReference();
    private boolean running;
    private BufferedReader is = null;
    private PrintWriter os = null;
    private Socket socket = null;
    private MergeableBitSet testRunning;

    public RainfallServerConnection(InetSocketAddress socketAddress, Socket socket, MergeableBitSet testRunning, String currentSessionId, int clientId) {
        this.socketAddress = socketAddress;
        this.socket = socket;
        this.testRunning = testRunning;
        this.currentSessionId = currentSessionId;
        this.clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.setupConnection();
            this.logger.info("[Rainfall server] New session created (id = {})", (Object)this.currentSessionId);
            while (this.running) {
                try {
                    String response = this.is.readLine();
                    if (response == null) {
                        Thread.sleep(2000L);
                        continue;
                    }
                    if ("READY".equalsIgnoreCase(response)) {
                        this.logger.debug("[Rainfall server] Waiting for all clients to connect : current state is {}", (Object)this.testRunning.toString());
                        this.testRunning.increase();
                        continue;
                    }
                    if (("FINISHED," + this.currentSessionId).equalsIgnoreCase(response)) {
                        this.stopClient();
                        this.running = false;
                        continue;
                    }
                    Thread.sleep(500L);
                }
                catch (IOException e) {
                    throw new TestException("Rainfall server couldn't read from a Rainfall client", e);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (TestException e) {
            this.testException.set(e);
        }
        finally {
            try {
                this.shutdown();
            }
            catch (IOException e) {
                this.logger.debug("[Rainfall server] Issue when shutting down connections", (Throwable)e);
            }
        }
    }

    private void shutdown() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void setupConnection() throws TestException {
        try {
            this.is = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.os = new PrintWriter(this.socket.getOutputStream());
            this.running = true;
            this.logger.info("[Rainfall server] waiting for clients");
        }
        catch (IOException e) {
            throw new TestException("Rainfall server couldn't start listening for clients", e);
        }
    }

    private void command(String command) {
        this.os.println(command);
        this.os.flush();
    }

    public void startClient() {
        this.logger.info("[Rainfall server] All clients connected - Sending GO to client {}", (Object)this.clientId);
        this.command("GO," + this.currentSessionId + "," + this.clientId);
    }

    public void stopClient() {
        this.logger.info("[Rainfall server] Sending shutdown to client {}", (Object)this.clientId);
        this.command("SHUTDOWN," + this.currentSessionId);
    }
}

