/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.consistency.ConsistencyService;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeerSet;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.v2.cleaner.EmptyServiceAutoCleaner;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.Message;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.ServiceStatusSynchronizer;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.Synchronizer;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.InstanceOperationContext;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ServiceManager
implements RecordListener<Service> {
    private final Map<String, Map<String, Service>> serviceMap = new ConcurrentHashMap<String, Map<String, Service>>();
    private final LinkedBlockingDeque<ServiceKey> toBeUpdatedServicesQueue = new LinkedBlockingDeque(0x100000);
    private final Synchronizer synchronizer = new ServiceStatusSynchronizer();
    @Resource(name="consistencyDelegate")
    private ConsistencyService consistencyService;
    private final SwitchDomain switchDomain;
    private final DistroMapper distroMapper;
    private final ServerMemberManager memberManager;
    private final UdpPushService pushService;
    private final RaftPeerSet raftPeerSet;
    @Value(value="${nacos.naming.empty-service.auto-clean:false}")
    private boolean emptyServiceAutoClean;
    @Value(value="${nacos.naming.empty-service.clean.initial-delay-ms:60000}")
    private int cleanEmptyServiceDelay;
    @Value(value="${nacos.naming.empty-service.clean.period-time-ms:20000}")
    private int cleanEmptyServicePeriod;

    public ServiceManager(SwitchDomain switchDomain, DistroMapper distroMapper, ServerMemberManager memberManager, UdpPushService pushService, RaftPeerSet raftPeerSet) {
        this.switchDomain = switchDomain;
        this.distroMapper = distroMapper;
        this.memberManager = memberManager;
        this.pushService = pushService;
        this.raftPeerSet = raftPeerSet;
    }

    @PostConstruct
    public void init() {
        GlobalExecutor.scheduleServiceReporter(new ServiceReporter(), 60000L, TimeUnit.MILLISECONDS);
        GlobalExecutor.submitServiceUpdateManager(new UpdatedServiceProcessor());
        if (this.emptyServiceAutoClean) {
            Loggers.SRV_LOG.info("open empty service auto clean job, initialDelay : {} ms, period : {} ms", (Object)this.cleanEmptyServiceDelay, (Object)this.cleanEmptyServicePeriod);
            GlobalExecutor.scheduleServiceAutoClean((Runnable)((Object)new EmptyServiceAutoCleaner(this, this.distroMapper)), this.cleanEmptyServiceDelay, this.cleanEmptyServicePeriod);
        }
        try {
            Loggers.SRV_LOG.info("listen for service meta change");
            this.consistencyService.listen("com.alibaba.nacos.naming.domains.meta.", this);
        }
        catch (NacosException e) {
            Loggers.SRV_LOG.error("listen for service meta change failed!");
        }
    }

    public Map<String, Service> chooseServiceMap(String namespaceId) {
        return this.serviceMap.get(namespaceId);
    }

    public synchronized void addUpdatedServiceToQueue(String namespaceId, String serviceName, String serverIP, String checksum) {
        try {
            this.toBeUpdatedServicesQueue.offer(new ServiceKey(namespaceId, serviceName, serverIP, checksum), 5L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.toBeUpdatedServicesQueue.poll();
            this.toBeUpdatedServicesQueue.add(new ServiceKey(namespaceId, serviceName, serverIP, checksum));
            Loggers.SRV_LOG.error("[DOMAIN-STATUS] Failed to add service to be updated to queue.", (Throwable)e);
        }
    }

    @Override
    public boolean interests(String key) {
        return KeyBuilder.matchServiceMetaKey(key) && !KeyBuilder.matchSwitchKey(key);
    }

    @Override
    public boolean matchUnlistenKey(String key) {
        return KeyBuilder.matchServiceMetaKey(key) && !KeyBuilder.matchSwitchKey(key);
    }

    @Override
    public void onChange(String key, Service service) throws Exception {
        try {
            if (service == null) {
                Loggers.SRV_LOG.warn("received empty push from raft, key: {}", (Object)key);
                return;
            }
            if (StringUtils.isBlank((CharSequence)service.getNamespaceId())) {
                service.setNamespaceId("public");
            }
            Loggers.RAFT.info("[RAFT-NOTIFIER] datum is changed, key: {}, value: {}", (Object)key, (Object)service);
            Service oldDom = this.getService(service.getNamespaceId(), service.getName());
            if (oldDom != null) {
                oldDom.update(service);
                this.consistencyService.listen(KeyBuilder.buildInstanceListKey(service.getNamespaceId(), service.getName(), true), oldDom);
                this.consistencyService.listen(KeyBuilder.buildInstanceListKey(service.getNamespaceId(), service.getName(), false), oldDom);
            } else {
                this.putServiceAndInit(service);
            }
        }
        catch (Throwable e) {
            Loggers.SRV_LOG.error("[NACOS-SERVICE] error while processing service update", e);
        }
    }

    @Override
    public void onDelete(String key) throws Exception {
        String namespace = KeyBuilder.getNamespace(key);
        String name = KeyBuilder.getServiceName(key);
        Service service = this.chooseServiceMap(namespace).get(name);
        Loggers.RAFT.info("[RAFT-NOTIFIER] datum is deleted, key: {}", (Object)key);
        if (service != null) {
            this.cleanupService(namespace, name, service);
        }
        this.chooseServiceMap(namespace).remove(name);
    }

    public RaftPeer getMySelfClusterState() {
        return this.raftPeerSet.local();
    }

    public void updatedHealthStatus(String namespaceId, String serviceName, String serverIP) {
        Message msg = this.synchronizer.get(serverIP, UtilsAndCommons.assembleFullServiceName(namespaceId, serviceName));
        JsonNode serviceJson = JacksonUtils.toObj((String)msg.getData());
        ArrayNode ipList = (ArrayNode)serviceJson.get("ips");
        HashMap<String, String> ipsMap = new HashMap<String, String>(ipList.size());
        for (int i = 0; i < ipList.size(); ++i) {
            String ip = ipList.get(i).asText();
            String[] strings = ip.split("_");
            ipsMap.put(strings[0], strings[1]);
        }
        Service service = this.getService(namespaceId, serviceName);
        if (service == null) {
            return;
        }
        boolean changed = false;
        List<Instance> instances = service.allIPs();
        for (Instance instance : instances) {
            boolean valid = Boolean.parseBoolean((String)ipsMap.get(instance.toIpAddr()));
            if (valid == instance.isHealthy()) continue;
            changed = true;
            instance.setHealthy(valid);
            Loggers.EVT_LOG.info("{} {SYNC} IP-{} : {}:{}@{}", new Object[]{serviceName, instance.isHealthy() ? "ENABLED" : "DISABLED", instance.getIp(), instance.getPort(), instance.getClusterName()});
        }
        if (changed) {
            this.pushService.serviceChanged(service);
            if (Loggers.EVT_LOG.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                List<Instance> allIps = service.allIPs();
                for (Instance instance : allIps) {
                    stringBuilder.append(instance.toIpAddr()).append('_').append(instance.isHealthy()).append(',');
                }
                Loggers.EVT_LOG.debug("[HEALTH-STATUS-UPDATED] namespace: {}, service: {}, ips: {}", new Object[]{service.getNamespaceId(), service.getName(), stringBuilder});
            }
        }
    }

    public Set<String> getAllServiceNames(String namespaceId) {
        return this.serviceMap.get(namespaceId).keySet();
    }

    public Map<String, Set<String>> getAllServiceNames() {
        HashMap<String, Set<String>> namesMap = new HashMap<String, Set<String>>(16);
        for (String namespaceId : this.serviceMap.keySet()) {
            namesMap.put(namespaceId, this.serviceMap.get(namespaceId).keySet());
        }
        return namesMap;
    }

    public Set<String> getAllNamespaces() {
        return this.serviceMap.keySet();
    }

    public List<String> getAllServiceNameList(String namespaceId) {
        if (this.chooseServiceMap(namespaceId) == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.chooseServiceMap(namespaceId).keySet());
    }

    public Map<String, Set<Service>> getResponsibleServices() {
        HashMap<String, Set<Service>> result = new HashMap<String, Set<Service>>(16);
        for (String namespaceId : this.serviceMap.keySet()) {
            result.put(namespaceId, new HashSet());
            for (Map.Entry<String, Service> entry : this.serviceMap.get(namespaceId).entrySet()) {
                Service service = entry.getValue();
                if (!this.distroMapper.responsible(entry.getKey())) continue;
                ((Set)result.get(namespaceId)).add(service);
            }
        }
        return result;
    }

    public int getResponsibleServiceCount() {
        int serviceCount = 0;
        for (String namespaceId : this.serviceMap.keySet()) {
            for (Map.Entry<String, Service> entry : this.serviceMap.get(namespaceId).entrySet()) {
                if (!this.distroMapper.responsible(entry.getKey())) continue;
                ++serviceCount;
            }
        }
        return serviceCount;
    }

    public int getResponsibleInstanceCount() {
        Map<String, Set<Service>> responsibleServices = this.getResponsibleServices();
        int count = 0;
        for (String namespaceId : responsibleServices.keySet()) {
            for (Service service : responsibleServices.get(namespaceId)) {
                count += service.allIPs().size();
            }
        }
        return count;
    }

    public void easyRemoveService(String namespaceId, String serviceName) throws NacosException {
        Service service = this.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(400, "specified service not exist, serviceName : " + serviceName);
        }
        this.consistencyService.remove(KeyBuilder.buildServiceMetaKey(namespaceId, serviceName));
    }

    public void addOrReplaceService(Service service) throws NacosException {
        this.consistencyService.put(KeyBuilder.buildServiceMetaKey(service.getNamespaceId(), service.getName()), service);
    }

    public void createEmptyService(String namespaceId, String serviceName, boolean local) throws NacosException {
        this.createServiceIfAbsent(namespaceId, serviceName, local, null);
    }

    public void createServiceIfAbsent(String namespaceId, String serviceName, boolean local, Cluster cluster) throws NacosException {
        Service service = this.getService(namespaceId, serviceName);
        if (service != null) {
            return;
        }
        Loggers.SRV_LOG.info("creating empty service {}:{}", (Object)namespaceId, (Object)serviceName);
        service = new Service();
        service.setName(serviceName);
        service.setNamespaceId(namespaceId);
        service.setGroupName(NamingUtils.getGroupName((String)serviceName));
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        if (cluster != null) {
            cluster.setService(service);
            service.getClusterMap().put(cluster.getName(), cluster);
        }
        service.validate();
        this.putServiceAndInit(service);
        if (!local) {
            this.addOrReplaceService(service);
        }
    }

    public void registerInstance(String namespaceId, String serviceName, Instance instance) throws NacosException {
        NamingUtils.checkInstanceIsLegal((com.alibaba.nacos.api.naming.pojo.Instance)instance);
        this.createEmptyService(namespaceId, serviceName, instance.isEphemeral());
        Service service = this.getService(namespaceId, serviceName);
        this.checkServiceIsNull(service, namespaceId, serviceName);
        this.addInstance(namespaceId, serviceName, instance.isEphemeral(), instance);
    }

    public void updateInstance(String namespaceId, String serviceName, Instance instance) throws NacosException {
        Service service = this.getService(namespaceId, serviceName);
        this.checkServiceIsNull(service, namespaceId, serviceName);
        if (!service.allIPs().contains(instance)) {
            throw new NacosException(400, "instance not exist: " + instance);
        }
        this.addInstance(namespaceId, serviceName, instance.isEphemeral(), instance);
    }

    public List<Instance> updateMetadata(String namespaceId, String serviceName, boolean isEphemeral, String action, boolean all, List<Instance> ips, Map<String, String> metadata) throws NacosException {
        Service service = this.getService(namespaceId, serviceName);
        this.checkServiceIsNull(service, namespaceId, serviceName);
        List<Instance> locatedInstance = this.getLocatedInstance(namespaceId, serviceName, isEphemeral, all, ips);
        if (CollectionUtils.isEmpty(locatedInstance)) {
            throw new NacosException(400, "not locate instances, input instances: " + ips);
        }
        if ("update".equals(action)) {
            locatedInstance.forEach(ele -> ele.getMetadata().putAll(metadata));
        } else if ("remove".equals(action)) {
            Set<String> removeKeys = metadata.keySet();
            for (String removeKey : removeKeys) {
                locatedInstance.forEach(ele -> ele.getMetadata().remove(removeKey));
            }
        }
        Instance[] instances = new Instance[locatedInstance.size()];
        locatedInstance.toArray(instances);
        this.addInstance(namespaceId, serviceName, isEphemeral, instances);
        return locatedInstance;
    }

    public void checkServiceIsNull(Service service, String namespaceId, String serviceName) throws NacosException {
        if (service == null) {
            throw new NacosException(400, "service not found, namespace: " + namespaceId + ", serviceName: " + serviceName);
        }
    }

    public List<Instance> getLocatedInstance(String namespaceId, String serviceName, boolean isEphemeral, boolean all, List<Instance> waitLocateInstance) throws NacosException {
        ArrayList<Instance> locatedInstance;
        Datum datum = this.consistencyService.get(KeyBuilder.buildInstanceListKey(namespaceId, serviceName, isEphemeral));
        if (datum == null) {
            throw new NacosException(404, "instances from consistencyService not exist, namespace: " + namespaceId + ", service: " + serviceName + ", ephemeral: " + isEphemeral);
        }
        if (all) {
            locatedInstance = ((Instances)datum.value).getInstanceList();
        } else {
            locatedInstance = new ArrayList();
            for (Instance instance : waitLocateInstance) {
                Instance located = this.locateInstance(((Instances)datum.value).getInstanceList(), instance);
                if (located == null) continue;
                locatedInstance.add(located);
            }
        }
        return locatedInstance;
    }

    private Instance locateInstance(List<Instance> sources, Instance target) {
        if (CollectionUtils.isEmpty(sources)) {
            return null;
        }
        for (Instance element : sources) {
            if (!Objects.equals(element, target) || !Objects.equals(element.getClusterName(), target.getClusterName())) continue;
            return element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstance(String namespaceId, String serviceName, boolean ephemeral, Instance ... ips) throws NacosException {
        Service service;
        String key = KeyBuilder.buildInstanceListKey(namespaceId, serviceName, ephemeral);
        Service service2 = service = this.getService(namespaceId, serviceName);
        synchronized (service2) {
            List<Instance> instanceList = this.addIpAddresses(service, ephemeral, ips);
            Instances instances = new Instances();
            instances.setInstanceList(instanceList);
            this.consistencyService.put(key, instances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(String namespaceId, String serviceName, boolean ephemeral, Instance ... ips) throws NacosException {
        Service service;
        Service service2 = service = this.getService(namespaceId, serviceName);
        synchronized (service2) {
            this.removeInstance(namespaceId, serviceName, ephemeral, service, ips);
        }
    }

    private void removeInstance(String namespaceId, String serviceName, boolean ephemeral, Service service, Instance ... ips) throws NacosException {
        String key = KeyBuilder.buildInstanceListKey(namespaceId, serviceName, ephemeral);
        List<Instance> instanceList = this.substractIpAddresses(service, ephemeral, ips);
        Instances instances = new Instances();
        instances.setInstanceList(instanceList);
        this.consistencyService.put(key, instances);
    }

    public Instance getInstance(String namespaceId, String serviceName, String cluster, String ip, int port) {
        Service service = this.getService(namespaceId, serviceName);
        if (service == null) {
            return null;
        }
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List<Instance> ips = service.allIPs(clusters);
        if (ips == null || ips.isEmpty()) {
            return null;
        }
        for (Instance instance : ips) {
            if (!instance.getIp().equals(ip) || instance.getPort() != port) continue;
            return instance;
        }
        return null;
    }

    public List<Instance> batchOperate(String namespace, InstanceOperationInfo operationInfo, Function<InstanceOperationContext, List<Instance>> operateFunction) {
        ArrayList<Instance> operatedInstances = new ArrayList<Instance>();
        try {
            String serviceName = operationInfo.getServiceName();
            NamingUtils.checkServiceNameFormat((String)serviceName);
            String type = operationInfo.getConsistencyType();
            if (!StringUtils.isEmpty((String)type)) {
                switch (type) {
                    case "ephemeral": {
                        InstanceOperationContext operationContext = new InstanceOperationContext(namespace, serviceName, true, true);
                        operatedInstances.addAll((Collection<Instance>)operateFunction.apply(operationContext));
                        break;
                    }
                    case "persist": {
                        InstanceOperationContext operationContext = new InstanceOperationContext(namespace, serviceName, false, true);
                        operatedInstances.addAll((Collection<Instance>)operateFunction.apply(operationContext));
                        break;
                    }
                    default: {
                        Loggers.SRV_LOG.warn("UPDATE-METADATA: services.all value is illegal, it should be ephemeral/persist. ignore the service '" + serviceName + "'");
                        break;
                    }
                }
            } else {
                List<? extends com.alibaba.nacos.api.naming.pojo.Instance> instances = operationInfo.getInstances();
                if (!CollectionUtils.isEmpty(instances)) {
                    Map<Boolean, List<Instance>> instanceMap = instances.stream().collect(Collectors.groupingBy(ele -> ele.isEphemeral()));
                    for (Map.Entry<Boolean, List<Instance>> entry : instanceMap.entrySet()) {
                        InstanceOperationContext operationContext = new InstanceOperationContext(namespace, serviceName, entry.getKey(), false, entry.getValue());
                        operatedInstances.addAll((Collection<Instance>)operateFunction.apply(operationContext));
                    }
                }
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("UPDATE-METADATA: update metadata failed, ignore the service '" + operationInfo.getServiceName() + "'", (Throwable)e);
        }
        return operatedInstances;
    }

    public List<Instance> updateIpAddresses(Service service, String action, boolean ephemeral, Instance ... ips) throws NacosException {
        Datum datum = this.consistencyService.get(KeyBuilder.buildInstanceListKey(service.getNamespaceId(), service.getName(), ephemeral));
        List<Instance> currentIPs = service.allIPs(ephemeral);
        HashMap<String, Instance> currentInstances = new HashMap<String, Instance>(currentIPs.size());
        Set currentInstanceIds = CollectionUtils.set((Object[])new String[0]);
        for (Instance instance : currentIPs) {
            currentInstances.put(instance.toIpAddr(), instance);
            currentInstanceIds.add(instance.getInstanceId());
        }
        Map<Object, Object> instanceMap = datum != null && null != datum.value ? this.setValid(((Instances)datum.value).getInstanceList(), currentInstances) : new HashMap(ips.length);
        for (Instance instance : ips) {
            if (!service.getClusterMap().containsKey(instance.getClusterName())) {
                Cluster cluster = new Cluster(instance.getClusterName(), service);
                cluster.init();
                service.getClusterMap().put(instance.getClusterName(), cluster);
                Loggers.SRV_LOG.warn("cluster: {} not found, ip: {}, will create new cluster with default configuration.", (Object)instance.getClusterName(), (Object)instance.toJson());
            }
            if ("remove".equals(action)) {
                instanceMap.remove(instance.getDatumKey());
                continue;
            }
            Instance oldInstance = (Instance)instanceMap.get(instance.getDatumKey());
            if (oldInstance != null) {
                instance.setInstanceId(oldInstance.getInstanceId());
            } else {
                instance.setInstanceId(instance.generateInstanceId(currentInstanceIds));
            }
            instanceMap.put(instance.getDatumKey(), instance);
        }
        if (instanceMap.size() <= 0 && "add".equals(action)) {
            throw new IllegalArgumentException("ip list can not be empty, service: " + service.getName() + ", ip list: " + JacksonUtils.toJson(instanceMap.values()));
        }
        return new ArrayList<Object>(instanceMap.values());
    }

    private List<Instance> substractIpAddresses(Service service, boolean ephemeral, Instance ... ips) throws NacosException {
        return this.updateIpAddresses(service, "remove", ephemeral, ips);
    }

    private List<Instance> addIpAddresses(Service service, boolean ephemeral, Instance ... ips) throws NacosException {
        return this.updateIpAddresses(service, "add", ephemeral, ips);
    }

    private Map<String, Instance> setValid(List<Instance> oldInstances, Map<String, Instance> map) {
        HashMap<String, Instance> instanceMap = new HashMap<String, Instance>(oldInstances.size());
        for (Instance instance : oldInstances) {
            Instance instance1 = map.get(instance.toIpAddr());
            if (instance1 != null) {
                instance.setHealthy(instance1.isHealthy());
                instance.setLastBeat(instance1.getLastBeat());
            }
            instanceMap.put(instance.getDatumKey(), instance);
        }
        return instanceMap;
    }

    public Service getService(String namespaceId, String serviceName) {
        Map<String, Service> service = this.serviceMap.get(namespaceId);
        if (service == null) {
            return null;
        }
        return service.get(serviceName);
    }

    public boolean containService(String namespaceId, String serviceName) {
        return this.getService(namespaceId, serviceName) != null;
    }

    public void putService(Service service) {
        if (!this.serviceMap.containsKey(service.getNamespaceId())) {
            this.serviceMap.putIfAbsent(service.getNamespaceId(), new ConcurrentSkipListMap());
        }
        this.serviceMap.get(service.getNamespaceId()).putIfAbsent(service.getName(), service);
    }

    private void putServiceAndInit(Service service) throws NacosException {
        this.putService(service);
        service = this.getService(service.getNamespaceId(), service.getName());
        service.init();
        this.consistencyService.listen(KeyBuilder.buildInstanceListKey(service.getNamespaceId(), service.getName(), true), service);
        this.consistencyService.listen(KeyBuilder.buildInstanceListKey(service.getNamespaceId(), service.getName(), false), service);
        Loggers.SRV_LOG.info("[NEW-SERVICE] {}", (Object)service.toJson());
    }

    public List<Service> searchServices(String namespaceId, String regex) {
        ArrayList<Service> result = new ArrayList<Service>();
        for (Map.Entry<String, Service> entry : this.chooseServiceMap(namespaceId).entrySet()) {
            Service service = entry.getValue();
            String key = service.getName() + ":" + service.getOwners().toString();
            if (!key.matches(regex)) continue;
            result.add(service);
        }
        return result;
    }

    public int getServiceCount() {
        int serviceCount = 0;
        for (String namespaceId : this.serviceMap.keySet()) {
            serviceCount += this.serviceMap.get(namespaceId).size();
        }
        return serviceCount;
    }

    public int getInstanceCount() {
        int total = 0;
        for (String namespaceId : this.serviceMap.keySet()) {
            for (Service service : this.serviceMap.get(namespaceId).values()) {
                total += service.allIPs().size();
            }
        }
        return total;
    }

    public int getPagedService(String namespaceId, int startPage, int pageSize, String param, String containedInstance, List<Service> serviceList, boolean hasIpCount) {
        List<Service> matchList;
        if (this.chooseServiceMap(namespaceId) == null) {
            return 0;
        }
        if (StringUtils.isNotBlank((String)param)) {
            StringJoiner regex = new StringJoiner("@@");
            for (String s2 : param.split("@@", 2)) {
                regex.add(StringUtils.isBlank((CharSequence)s2) ? ".*" : ".*" + s2 + ".*");
            }
            matchList = this.searchServices(namespaceId, regex.toString());
        } else {
            matchList = new ArrayList<Service>(this.chooseServiceMap(namespaceId).values());
        }
        if (!CollectionUtils.isEmpty(matchList) && hasIpCount) {
            matchList = matchList.stream().filter(s -> !CollectionUtils.isEmpty(s.allIPs())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((String)containedInstance)) {
            for (int i = 0; i < matchList.size(); ++i) {
                Service service = matchList.get(i);
                boolean contained = false;
                List<Instance> instances = service.allIPs();
                for (Instance instance : instances) {
                    if (InternetAddressUtil.containsPort((String)containedInstance)) {
                        if (!StringUtils.equals((String)(instance.getIp() + ":" + instance.getPort()), (String)containedInstance)) continue;
                        contained = true;
                        break;
                    }
                    if (!StringUtils.equals((String)instance.getIp(), (String)containedInstance)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                matchList.remove(i);
                --i;
            }
        }
        if (pageSize >= matchList.size()) {
            serviceList.addAll(matchList);
            return matchList.size();
        }
        for (int i = 0; i < matchList.size(); ++i) {
            if (i < startPage * pageSize) continue;
            serviceList.add(matchList.get(i));
            if (serviceList.size() >= pageSize) break;
        }
        return matchList.size();
    }

    public void shutdown() throws NacosException {
        try {
            long start = System.nanoTime();
            Loggers.SRV_LOG.info("Start to destroy ALL services. namespaces: {}, services: {}", (Object)this.serviceMap.keySet().size(), (Object)this.getServiceCount());
            Iterator<Map.Entry<String, Map<String, Service>>> iterator = this.serviceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<String, Service>> entry = iterator.next();
                this.destroyAllService(entry.getKey(), entry.getValue());
                iterator.remove();
            }
            Loggers.SRV_LOG.info(String.format("Successfully destroy ALL services. costs %.2fms", (double)(System.nanoTime() - start) * 1.0E-6));
        }
        catch (Exception e) {
            throw new NacosException(500, "shutdown serviceManager failed", (Throwable)e);
        }
    }

    private void destroyAllService(String namespace, Map<String, Service> serviceMap) throws Exception {
        Iterator<Map.Entry<String, Service>> iterator = serviceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Service> entry = iterator.next();
            Service service = entry.getValue();
            String name = service.getName();
            this.cleanupService(namespace, name, service);
            iterator.remove();
        }
    }

    private void cleanupService(String namespace, String name, Service service) throws Exception {
        service.destroy();
        String ephemeralInstanceListKey = KeyBuilder.buildInstanceListKey(namespace, name, true);
        String persistInstanceListKey = KeyBuilder.buildInstanceListKey(namespace, name, false);
        String serviceMetaKey = KeyBuilder.buildServiceMetaKey(namespace, name);
        this.consistencyService.remove(ephemeralInstanceListKey);
        this.consistencyService.remove(persistInstanceListKey);
        this.consistencyService.remove(serviceMetaKey);
        this.consistencyService.unListen(ephemeralInstanceListKey, service);
        this.consistencyService.unListen(persistInstanceListKey, service);
        this.consistencyService.unListen(serviceMetaKey, service);
        Loggers.SRV_LOG.info("[DEAD-SERVICE] {}", (Object)service.toJson());
    }

    private static class ServiceKey {
        private String namespaceId;
        private String serviceName;
        private String serverIP;
        private String checksum;

        public String getChecksum() {
            return this.checksum;
        }

        public String getServerIP() {
            return this.serverIP;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getNamespaceId() {
            return this.namespaceId;
        }

        public ServiceKey(String namespaceId, String serviceName, String serverIP, String checksum) {
            this.namespaceId = namespaceId;
            this.serviceName = serviceName;
            this.serverIP = serverIP;
            this.checksum = checksum;
        }

        public String toString() {
            return JacksonUtils.toJson((Object)this);
        }
    }

    private class ServiceReporter
    implements Runnable {
        private ServiceReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Map<String, Set<String>> allServiceNames = ServiceManager.this.getAllServiceNames();
                if (allServiceNames.size() <= 0) {
                    return;
                }
                for (String namespaceId : allServiceNames.keySet()) {
                    ServiceChecksum checksum = new ServiceChecksum(namespaceId);
                    for (String serviceName : allServiceNames.get(namespaceId)) {
                        Service service;
                        if (!ServiceManager.this.distroMapper.responsible(serviceName) || (service = ServiceManager.this.getService(namespaceId, serviceName)) == null || service.isEmpty()) continue;
                        service.recalculateChecksum();
                        checksum.addItem(serviceName, service.getChecksum());
                    }
                    Message msg = new Message();
                    msg.setData(JacksonUtils.toJson((Object)checksum));
                    Collection sameSiteServers = ServiceManager.this.memberManager.allMembers();
                    if (sameSiteServers == null || sameSiteServers.size() <= 0) {
                        return;
                    }
                    for (Member server : sameSiteServers) {
                        if (server.getAddress().equals(NetUtils.localServer())) continue;
                        ServiceManager.this.synchronizer.send(server.getAddress(), msg);
                    }
                }
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("[DOMAIN-STATUS] Exception while sending service status", (Throwable)e);
            }
            finally {
                GlobalExecutor.scheduleServiceReporter(this, ServiceManager.this.switchDomain.getServiceStatusSynchronizationPeriodMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class ServiceChecksum {
        public String namespaceId;
        public Map<String, String> serviceName2Checksum = new HashMap<String, String>();

        public ServiceChecksum() {
            this.namespaceId = "public";
        }

        public ServiceChecksum(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        public void addItem(String serviceName, String checksum) {
            if (StringUtils.isEmpty((String)serviceName) || StringUtils.isEmpty((String)checksum)) {
                Loggers.SRV_LOG.warn("[DOMAIN-CHECKSUM] serviceName or checksum is empty,serviceName: {}, checksum: {}", (Object)serviceName, (Object)checksum);
                return;
            }
            this.serviceName2Checksum.put(serviceName, checksum);
        }
    }

    private class ServiceUpdater
    implements Runnable {
        String namespaceId;
        String serviceName;
        String serverIP;

        public ServiceUpdater(ServiceKey serviceKey) {
            this.namespaceId = serviceKey.getNamespaceId();
            this.serviceName = serviceKey.getServiceName();
            this.serverIP = serviceKey.getServerIP();
        }

        @Override
        public void run() {
            try {
                ServiceManager.this.updatedHealthStatus(this.namespaceId, this.serviceName, this.serverIP);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("[DOMAIN-UPDATER] Exception while update service: {} from {}, error: {}", new Object[]{this.serviceName, this.serverIP, e});
            }
        }
    }

    private class UpdatedServiceProcessor
    implements Runnable {
        private UpdatedServiceProcessor() {
        }

        @Override
        public void run() {
            ServiceKey serviceKey = null;
            try {
                while (true) {
                    try {
                        serviceKey = (ServiceKey)ServiceManager.this.toBeUpdatedServicesQueue.take();
                    }
                    catch (Exception e) {
                        Loggers.EVT_LOG.error("[UPDATE-DOMAIN] Exception while taking item from LinkedBlockingDeque.");
                    }
                    if (serviceKey == null) continue;
                    GlobalExecutor.submitServiceUpdate(new ServiceUpdater(serviceKey));
                }
            }
            catch (Exception e) {
                Loggers.EVT_LOG.error("[UPDATE-DOMAIN] Exception while update service: {}", (Object)serviceKey, (Object)e);
                return;
            }
        }
    }
}

