/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion.target;

import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.AbstractCoercionTarget;
import net.stickycode.coercion.target.ArrayCoercionTargetsMustTargetArraysException;
import net.stickycode.coercion.target.CoercionTargets;

public class ArrayCoercionTarget
extends AbstractCoercionTarget {
    public ArrayCoercionTarget(Class<?> type, Class<?> owner, CoercionTarget parent, String name) {
        super(type, owner, parent, name);
        if (!type.isArray()) {
            throw new ArrayCoercionTargetsMustTargetArraysException(type);
        }
    }

    @Override
    public boolean hasComponents() {
        return true;
    }

    @Override
    public CoercionTarget[] getComponentCoercionTypes() {
        return new CoercionTarget[]{CoercionTargets.find(this.type.getComponentType())};
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public int hashCode() {
        return 31 * this.type.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayCoercionTarget other = (ArrayCoercionTarget)obj;
        if (this.type == null && other.type != null) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.type.getSimpleName() + "}";
    }
}

