/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import org.anyline.data.entity.Join;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.entity.Aggregation;
import org.anyline.entity.AggregationConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultGroupStore;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.GroupStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Column;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

public abstract class AbstractRunPrepare
implements RunPrepare {
    protected static final Log log = LogProxy.get(AbstractRunPrepare.class);
    protected String id;
    protected boolean disposable = false;
    protected String text;
    protected ConditionChain chain;
    protected OrderStore orders = new DefaultOrderStore();
    protected GroupStore groups = new DefaultGroupStore();
    protected List<AggregationConfig> aggregations = new ArrayList<AggregationConfig>();
    protected ConfigStore having = new DefaultConfigStore(new String[0]);
    protected String box;
    protected PageNavi navi;
    protected List<String> primaryKeys = new ArrayList<String>();
    protected List<String> fetchKeys = new ArrayList<String>();
    protected boolean valid = true;
    protected String alias;
    protected int batch = 0;
    protected boolean multiple = false;
    protected boolean strict = false;
    protected String runtime = null;
    protected Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();
    protected List<String> excludes = new ArrayList<String>();
    protected String distinct = "";
    protected ConfigStore condition;
    protected Join join;
    protected Boolean isSub = null;
    protected boolean unionAll = false;
    protected List<RunPrepare> unions = new ArrayList<RunPrepare>();
    protected List<RunPrepare> joins = new ArrayList<RunPrepare>();
    protected Vector<Object> runValues;

    @Override
    public int getVersion() {
        return 0;
    }

    protected void initRunValues() {
        if (null == this.runValues) {
            this.runValues = new Vector();
        } else {
            this.runValues.clear();
        }
    }

    @Override
    public RunPrepare order(Order order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.add(order);
        return this;
    }

    @Override
    public RunPrepare order(String order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.add(order);
        return this;
    }

    @Override
    public RunPrepare order(String col, Order.TYPE type) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.add(col, type);
        return this;
    }

    @Override
    public RunPrepare order(OrderStore orders) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.add(orders);
        return this;
    }

    @Override
    public RunPrepare group(String ... groups) {
        if (null != groups) {
            if (null == this.groups) {
                this.groups = new DefaultGroupStore();
            }
            for (String group : groups) {
                if (BasicUtil.isEmpty((Object)group)) continue;
                group = group.trim();
                this.groups.add(group);
            }
        }
        return this;
    }

    @Override
    public RunPrepare group(GroupStore groups) {
        if (null != groups) {
            if (null == this.groups) {
                this.groups = new DefaultGroupStore();
            }
            this.groups.add(groups);
        }
        return this;
    }

    @Override
    public RunPrepare having(String having) {
        if (null == this.having) {
            this.having = new DefaultConfigStore(new String[0]);
        }
        this.having.and(having);
        return this;
    }

    @Override
    public RunPrepare having(ConfigStore having) {
        if (null == this.having) {
            this.having = having;
        } else {
            this.having.and(having);
        }
        return this;
    }

    protected RunPrepare addRunValue(Object runValue) {
        if (null == this.runValues) {
            this.runValues = new Vector();
        }
        if (runValue instanceof Collection) {
            Collection collection = (Collection)runValue;
            this.runValues.addAll(collection);
        } else {
            this.runValues.add(runValue);
        }
        return this;
    }

    public List<Object> getRunValues() {
        return this.runValues;
    }

    public RunPrepare setConditionChain(ConditionChain chain) {
        this.chain = chain;
        return this;
    }

    @Override
    public RunPrepare addCondition(Condition condition) {
        this.chain.addCondition(condition);
        return this;
    }

    @Override
    public RunPrepare setConditionValue(String condition, String variable, Object value) {
        return this;
    }

    @Override
    public RunPrepare addCondition(Compare compare, String column, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(Compare.EMPTY_VALUE_SWITCH.IGNORE, compare, null, column, value);
        this.addCondition(condition);
        return this;
    }

    public RunPrepare addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String column, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, null, column, value);
        this.addCondition(condition);
        return this;
    }

    @Override
    public RunPrepare addCondition(String column, Object value) {
        Compare compare = Compare.EQUAL;
        if (value instanceof Collection) {
            compare = Compare.IN;
        }
        return this.addCondition(compare, column, value);
    }

    @Override
    public RunPrepare setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void setPageNavi(PageNavi navi) {
        this.navi = navi;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public ConfigStore having() {
        return this.having;
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public void setOrders(OrderStore orders) {
        if (null != orders) {
            this.orders.add(orders);
        } else {
            this.orders.clear();
        }
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.chain;
    }

    @Override
    public RunPrepare addPrimaryKey(String ... primaryKeys) {
        if (null != primaryKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : primaryKeys) {
                list.add(pk);
            }
            return this.addPrimaryKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare addPrimaryKey(Collection<String> primaryKeys) {
        if (BasicUtil.isEmpty(primaryKeys)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : primaryKeys) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item = item.toUpperCase())) continue;
            this.primaryKeys.add(item);
        }
        return this;
    }

    @Override
    public RunPrepare setPrimaryKey(String ... primaryKeys) {
        if (null != primaryKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : primaryKeys) {
                list.add(pk);
            }
            return this.setPrimaryKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare setPrimaryKey(Collection<String> primaryKeys) {
        if (BasicUtil.isEmpty(primaryKeys)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        this.addPrimaryKey(primaryKeys);
        return this;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && !keys.isEmpty()) {
            return keys.get(0);
        }
        return null;
    }

    @Override
    public boolean hasPrimaryKeys() {
        return null != this.primaryKeys && !this.primaryKeys.isEmpty();
    }

    @Override
    public String getDistinct() {
        return this.distinct;
    }

    @Override
    public RunPrepare setDistinct(boolean distinct) {
        this.distinct = distinct ? "distinct" : "";
        return this;
    }

    @Override
    public RunPrepare addFetchKey(String ... fetchKeys) {
        if (null != fetchKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : fetchKeys) {
                list.add(pk);
            }
            return this.addFetchKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare addFetchKey(Collection<String> fetchKeys) {
        if (BasicUtil.isEmpty(fetchKeys)) {
            return this;
        }
        if (null == this.fetchKeys) {
            this.fetchKeys = new ArrayList<String>();
        }
        for (String item : fetchKeys) {
            if (BasicUtil.isEmpty((Object)item) || this.fetchKeys.contains(item = item.toUpperCase())) continue;
            this.fetchKeys.add(item);
        }
        return this;
    }

    @Override
    public RunPrepare setFetchKey(String ... fetchKeys) {
        if (null != fetchKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : fetchKeys) {
                list.add(pk);
            }
            return this.setFetchKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare setFetchKey(Collection<String> fetchKeys) {
        if (BasicUtil.isEmpty(fetchKeys)) {
            return this;
        }
        if (null == this.fetchKeys) {
            this.fetchKeys = new ArrayList<String>();
        } else {
            this.fetchKeys.clear();
        }
        this.addFetchKey(fetchKeys);
        return this;
    }

    @Override
    public List<String> getFetchKeys() {
        return this.fetchKeys;
    }

    public RunPrepare join(Join.TYPE type, Table table, String ... conditions) {
        Join join = new Join();
        join.setType(type);
        join.setConditions(conditions);
        DefaultTablePrepare prepare = new DefaultTablePrepare(table);
        prepare.setJoin(join);
        this.joins.add(prepare);
        return this;
    }

    @Override
    public RunPrepare join(Join.TYPE type, String table, String condition) {
        return this.join(type, new Table(table), condition);
    }

    @Override
    public RunPrepare inner(String table, String condition) {
        return this.join(Join.TYPE.INNER, table, condition);
    }

    public RunPrepare inner(Table table, String condition) {
        return this.join(Join.TYPE.INNER, table, condition);
    }

    @Override
    public RunPrepare left(String table, String condition) {
        return this.join(Join.TYPE.LEFT, table, condition);
    }

    public RunPrepare left(Table table, String condition) {
        return this.join(Join.TYPE.LEFT, table, condition);
    }

    @Override
    public RunPrepare right(String table, String condition) {
        return this.join(Join.TYPE.RIGHT, table, condition);
    }

    public RunPrepare right(Table table, String condition) {
        return this.join(Join.TYPE.RIGHT, table, condition);
    }

    @Override
    public RunPrepare full(String table, String condition) {
        return this.join(Join.TYPE.FULL, table, condition);
    }

    public RunPrepare full(Table table, String condition) {
        return this.join(Join.TYPE.FULL, table, condition);
    }

    @Override
    public RunPrepare join(RunPrepare prepare) {
        this.joins.add(prepare);
        return this;
    }

    @Override
    public Join getJoin() {
        return this.join;
    }

    @Override
    public RunPrepare setJoin(Join join) {
        this.join = join;
        return this;
    }

    @Override
    public List<RunPrepare> getJoins() {
        return this.joins;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public RunPrepare setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public RunPrepare setMultiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RunPrepare setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean disposable() {
        return this.disposable;
    }

    @Override
    public RunPrepare disposable(boolean disposable) {
        this.disposable = disposable;
        return this;
    }

    @Override
    public String getRuntime() {
        return this.runtime;
    }

    @Override
    public RunPrepare setRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public RunPrepare setQueryColumns(String ... columns) {
        if (null != columns) {
            this.setQueryColumns(BeanUtil.array2list((Object[][])new String[][]{columns}));
        }
        return this;
    }

    @Override
    public RunPrepare setQueryColumns(List<String> columns) {
        this.columns = new LinkedHashMap();
        for (String column : columns) {
            this.columns.put(column.toUpperCase(), new Column(column));
        }
        return this;
    }

    @Override
    public LinkedHashMap<String, Column> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public RunPrepare setExcludeColumns(List<String> excludeColumn) {
        this.excludes = excludeColumn;
        return this;
    }

    @Override
    public RunPrepare setExcludeColumns(String ... columns) {
        if (null != columns) {
            this.excludes = BeanUtil.array2list((Object[][])new String[][]{columns});
        }
        return this;
    }

    @Override
    public int getBatch() {
        return this.batch;
    }

    @Override
    public void setBatch(int batch) {
        this.batch = batch;
    }

    @Override
    public ConfigStore condition() {
        return this.condition;
    }

    @Override
    public RunPrepare condition(ConfigStore condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public RunPrepare setUnionAll(boolean all) {
        this.unionAll = all;
        return this;
    }

    @Override
    public boolean isUnionAll() {
        return this.unionAll;
    }

    @Override
    public RunPrepare union(RunPrepare prepare, boolean all) {
        prepare.setUnionAll(all);
        this.unions.add(prepare);
        return this;
    }

    @Override
    public RunPrepare union(RunPrepare prepare) {
        this.unions.add(prepare);
        return this;
    }

    @Override
    public RunPrepare union(List<RunPrepare> unions, boolean all) {
        for (RunPrepare union : unions) {
            this.union(union, all);
        }
        return this;
    }

    @Override
    public RunPrepare union(List<RunPrepare> unions) {
        for (RunPrepare union : unions) {
            this.union(union);
        }
        return this;
    }

    @Override
    public List<RunPrepare> getUnions() {
        return this.unions;
    }

    @Override
    public GroupStore groups() {
        return this.groups;
    }

    @Override
    public RunPrepare aggregation(Aggregation aggregation, String column, String result) {
        AggregationConfig config = new AggregationConfig(aggregation, column, result);
        this.aggregations.add(config);
        return this;
    }

    @Override
    public RunPrepare aggregation(AggregationConfig ... configs) {
        for (AggregationConfig config : configs) {
            this.aggregations.add(config);
        }
        return this;
    }

    @Override
    public RunPrepare aggregation(List<AggregationConfig> configs) {
        for (AggregationConfig config : configs) {
            this.aggregations.add(config);
        }
        return this;
    }

    @Override
    public List<AggregationConfig> aggregations() {
        return this.aggregations;
    }

    @Override
    public RunPrepare box(String box) {
        this.box = box;
        return this;
    }

    @Override
    public RunPrepare clone() {
        AbstractRunPrepare clone = null;
        try {
            clone = (AbstractRunPrepare)super.clone();
            clone.id = this.id;
            clone.disposable(true);
            clone.text = this.text;
            clone.chain = this.chain == null ? null : this.chain.clone();
            clone.orders = this.orders.clone();
            clone.groups = this.groups.clone();
            clone.having = this.having;
            clone.navi = this.navi == null ? null : this.navi.clone();
            clone.primaryKeys = new ArrayList<String>(this.primaryKeys);
            clone.fetchKeys = new ArrayList<String>(this.fetchKeys);
            clone.valid = this.valid;
            clone.alias = this.alias;
            clone.batch = this.batch;
            clone.multiple = this.multiple;
            clone.strict = this.strict;
            clone.runtime = this.runtime;
            clone.swt = this.swt;
            LinkedHashMap<String, Metadata> cols = new LinkedHashMap<String, Metadata>();
            for (String string : this.columns.keySet()) {
                cols.put(string, this.columns.get(string).clone());
            }
            clone.columns = cols;
            clone.excludes = new ArrayList<String>(this.excludes);
            clone.distinct = this.distinct;
            clone.condition = this.condition == null ? null : this.condition.clone();
            clone.join = this.join;
            clone.isSub = this.isSub;
            clone.unionAll = this.unionAll;
            ArrayList<RunPrepare> unions = new ArrayList<RunPrepare>();
            for (RunPrepare union : this.unions) {
                unions.add(union.clone());
            }
            clone.unions = unions;
            ArrayList<RunPrepare> arrayList = new ArrayList<RunPrepare>();
            for (RunPrepare join : this.joins) {
                arrayList.add(join.clone());
            }
            clone.joins = arrayList;
            this.runValues = this.runValues == null ? null : new Vector<Object>(this.runValues);
        }
        catch (Exception e) {
            log.error("RunPrepare clone", (Throwable)e);
        }
        return clone;
    }
}

