/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetable;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.nodetable.NodeTableNative;
import org.apache.jena.tdb2.store.nodetable.TReadAppendFileTransport;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class NodeTableTRDF
extends NodeTableNative {
    private final BinaryDataFile diskFile;
    private final TReadAppendFileTransport transport;
    private final TProtocol protocol;

    public NodeTableTRDF(Index nodeToId, BinaryDataFile objectFile) {
        super(nodeToId);
        try {
            this.diskFile = objectFile;
            this.transport = new TReadAppendFileTransport(this.diskFile);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
            this.protocol = TRDF.protocol((TTransport)this.transport);
        }
        catch (Exception ex) {
            throw new TDBException("NodeTableTRDF", ex);
        }
    }

    @Override
    protected NodeId writeNodeToTable(Node node) {
        RDF_Term term = ThriftConvert.convert((Node)node, (boolean)true);
        try {
            long x = this.diskFile.length();
            NodeId nid = NodeIdFactory.createPtr(x);
            term.write(this.protocol);
            return nid;
        }
        catch (Exception ex) {
            throw new TDBException("NodeTableThrift/Write", ex);
        }
    }

    @Override
    protected Node readNodeFromTable(NodeId id) {
        try {
            long x = id.getPtrLocation();
            this.transport.readPosition(x);
            RDF_Term term = new RDF_Term();
            term.read(this.protocol);
            Node n = ThriftConvert.convert((RDF_Term)term);
            return n;
        }
        catch (TException ex) {
            throw new TDBException("NodeTableTRDF/Read", ex);
        }
        catch (RiotThriftException ex) {
            Log.error((Object)this, (String)("Bad encoding: NodeId = " + id));
            throw ex;
        }
    }

    @Override
    protected void syncSub() {
        try {
            this.transport.flush();
        }
        catch (Exception ex) {
            throw new TDBException("NodeTableTRDF", ex);
        }
    }

    @Override
    protected void closeSub() {
        if (this.transport.isOpen()) {
            try {
                this.transport.close();
            }
            catch (Exception ex) {
                throw new TDBException("NodeTableTRDF", ex);
            }
        }
    }

    public Index getIndex() {
        return this.nodeHashToId;
    }

    public BinaryDataFile getData() {
        return this.diskFile;
    }
}

