/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.clean.Cleaner;
import org.apache.maven.plugins.clean.Fileset;
import org.apache.maven.plugins.clean.GlobSelector;

@Mojo(name="clean", threadSafe=true)
public class CleanMojo
extends AbstractMojo {
    public static final String FAST_MODE_BACKGROUND = "background";
    public static final String FAST_MODE_AT_END = "at-end";
    public static final String FAST_MODE_DEFER = "defer";
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File directory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true, required=true)
    private File testOutputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File reportDirectory;
    @Parameter(property="maven.clean.verbose")
    private Boolean verbose;
    @Parameter
    private Fileset[] filesets;
    @Parameter(property="maven.clean.followSymLinks", defaultValue="false")
    private boolean followSymLinks;
    @Parameter(property="maven.clean.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.clean.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="maven.clean.retryOnError", defaultValue="true")
    private boolean retryOnError;
    @Parameter(property="maven.clean.excludeDefaultDirectories", defaultValue="false")
    private boolean excludeDefaultDirectories;
    @Parameter(property="maven.clean.fast", defaultValue="false")
    private boolean fast;
    @Parameter(property="maven.clean.fastDir")
    private File fastDir;
    @Parameter(property="maven.clean.fastMode", defaultValue="background")
    private String fastMode;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        Path fastDir;
        String multiModuleProjectDirectory;
        if (this.skip) {
            this.getLog().info((CharSequence)"Clean is skipped.");
            return;
        }
        String string = multiModuleProjectDirectory = this.session != null ? this.session.getSystemProperties().getProperty("maven.multiModuleProjectDirectory") : null;
        if (this.fast && this.fastDir != null) {
            fastDir = CleanMojo.toNullablePath(this.fastDir);
        } else if (this.fast && multiModuleProjectDirectory != null) {
            fastDir = FileSystems.getDefault().getPath(multiModuleProjectDirectory, new String[0]).resolve("target").resolve(".clean");
        } else {
            fastDir = null;
            if (this.fast) {
                this.getLog().warn((CharSequence)"Fast clean requires maven 3.3.1 or newer, or an explicit directory to be specified with the 'fastDir' configuration of this plugin, or the 'maven.clean.fastDir' user property to be set.");
            }
        }
        if (this.fast && !FAST_MODE_BACKGROUND.equals(this.fastMode) && !FAST_MODE_AT_END.equals(this.fastMode) && !FAST_MODE_DEFER.equals(this.fastMode)) {
            throw new IllegalArgumentException("Illegal value '" + this.fastMode + "' for fastMode. Allowed values are '" + FAST_MODE_BACKGROUND + "', '" + FAST_MODE_AT_END + "' and '" + FAST_MODE_DEFER + "'.");
        }
        Cleaner cleaner = new Cleaner(this.session, this.getLog(), this.isVerbose(), fastDir, this.fastMode);
        try {
            for (Path directoryItem : this.getDirectories()) {
                if (directoryItem == null) continue;
                cleaner.delete(directoryItem, null, this.followSymLinks, this.failOnError, this.retryOnError);
            }
            if (this.filesets != null) {
                for (Fileset fileset : this.filesets) {
                    if (fileset.getDirectory() == null) {
                        throw new MojoExecutionException("Missing base directory for " + fileset);
                    }
                    String[] includes = fileset.getIncludes();
                    String[] excludes = fileset.getExcludes();
                    boolean useDefaultExcludes = fileset.isUseDefaultExcludes();
                    GlobSelector selector = includes != null && includes.length != 0 || excludes != null && excludes.length != 0 || useDefaultExcludes ? new GlobSelector(includes, excludes, useDefaultExcludes) : null;
                    cleaner.delete(fileset.getDirectory().toPath(), selector, fileset.isFollowSymlinks(), this.failOnError, this.retryOnError);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to clean project: " + e.getMessage(), (Exception)e);
        }
    }

    private boolean isVerbose() {
        return this.verbose != null ? this.verbose.booleanValue() : this.getLog().isDebugEnabled();
    }

    private Path[] getDirectories() {
        Path[] directories = this.excludeDefaultDirectories ? new Path[]{} : new Path[]{CleanMojo.toNullablePath(this.directory), CleanMojo.toNullablePath(this.outputDirectory), CleanMojo.toNullablePath(this.testOutputDirectory), CleanMojo.toNullablePath(this.reportDirectory)};
        return directories;
    }

    private static Path toNullablePath(File file) {
        return file != null ? file.toPath() : null;
    }
}

