/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.data.swapper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.util.yaml.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereTableData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereColumn;

public final class YamlShardingSphereTableDataSwapper
implements YamlConfigurationSwapper<YamlShardingSphereTableData, ShardingSphereTableData> {
    public YamlShardingSphereTableData swapToYamlConfiguration(ShardingSphereTableData data) {
        YamlShardingSphereTableData result = new YamlShardingSphereTableData();
        result.setName(data.getName());
        LinkedList<YamlShardingSphereRowData> rowData = new LinkedList<YamlShardingSphereRowData>();
        data.getRows().forEach(each -> rowData.add(this.swapYamlRow((ShardingSphereRowData)each, data.getColumns())));
        result.setRows(rowData);
        LinkedList<YamlShardingSphereColumn> columns = new LinkedList<YamlShardingSphereColumn>();
        data.getColumns().forEach(each -> columns.add(this.swapYamlColumn((ShardingSphereColumn)each)));
        result.setColumns(columns);
        return result;
    }

    private YamlShardingSphereRowData swapYamlRow(ShardingSphereRowData row, List<ShardingSphereColumn> columns) {
        YamlShardingSphereRowData result = new YamlShardingSphereRowData();
        List<Object> rowData = null == row.getRows() ? Collections.emptyList() : row.getRows();
        LinkedList<Object> yamlRowData = new LinkedList<Object>();
        int count = 0;
        for (Object each : rowData) {
            yamlRowData.add(this.convertDataType(each, columns.get(count++).getDataType()));
        }
        result.setRows(yamlRowData);
        return result;
    }

    private Object convertDataType(Object data, int dataType) {
        if (3 == dataType) {
            return data.toString();
        }
        return data;
    }

    private YamlShardingSphereColumn swapYamlColumn(ShardingSphereColumn column) {
        YamlShardingSphereColumn result = new YamlShardingSphereColumn();
        result.setName(column.getName());
        result.setCaseSensitive(column.isCaseSensitive());
        result.setGenerated(column.isGenerated());
        result.setPrimaryKey(column.isPrimaryKey());
        result.setDataType(column.getDataType());
        result.setVisible(column.isVisible());
        return result;
    }

    public ShardingSphereTableData swapToObject(YamlShardingSphereTableData yamlConfig) {
        LinkedList<ShardingSphereColumn> columns = new LinkedList<ShardingSphereColumn>();
        if (null != yamlConfig.getColumns()) {
            yamlConfig.getColumns().forEach(each -> columns.add(this.swapColumn((YamlShardingSphereColumn)each)));
        }
        ShardingSphereTableData result = new ShardingSphereTableData(yamlConfig.getName(), columns);
        if (null != yamlConfig.getRows()) {
            yamlConfig.getRows().forEach(each -> result.getRows().add(this.swapRow((YamlShardingSphereRowData)each, yamlConfig.getColumns())));
        }
        return result;
    }

    private ShardingSphereRowData swapRow(YamlShardingSphereRowData yamlRowData, List<YamlShardingSphereColumn> columns) {
        List<Object> yamlRow = null == yamlRowData.getRows() ? Collections.emptyList() : yamlRowData.getRows();
        LinkedList<Object> rowData = new LinkedList<Object>();
        int count = 0;
        for (Object each : yamlRow) {
            YamlShardingSphereColumn yamlColumn = columns.get(count++);
            rowData.add(this.convertByDataType(each, yamlColumn.getDataType()));
        }
        return new ShardingSphereRowData(rowData);
    }

    private Object convertByDataType(Object data, int dataType) {
        if (3 == dataType) {
            return new BigDecimal(data.toString());
        }
        return data;
    }

    private ShardingSphereColumn swapColumn(YamlShardingSphereColumn column) {
        return new ShardingSphereColumn(column.getName(), column.getDataType(), column.isPrimaryKey(), column.isGenerated(), column.isCaseSensitive(), column.isVisible());
    }
}

