/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.stream;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Calendar;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public abstract class StreamMergedResult
implements MergedResult {
    private QueryResult currentQueryResult;
    private boolean wasNull;

    protected final QueryResult getCurrentQueryResult() throws SQLException {
        ShardingSpherePreconditions.checkNotNull((Object)this.currentQueryResult, () -> new SQLException("Current ResultSet is null, ResultSet perhaps end of next"));
        return this.currentQueryResult;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Object result = this.getCurrentQueryResult().getValue(columnIndex, type);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        Object result = this.getCurrentQueryResult().getCalendarValue(columnIndex, type, calendar);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        InputStream result = this.getCurrentQueryResult().getInputStream(columnIndex, type);
        this.wasNull = this.getCurrentQueryResult().wasNull();
        return result;
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    @Generated
    public void setCurrentQueryResult(QueryResult currentQueryResult) {
        this.currentQueryResult = currentQueryResult;
    }

    @Generated
    public void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }
}

