/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingResult;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.externaltask.LockedExternalTaskImpl;
import org.camunda.bpm.engine.impl.externaltask.TopicFetchInstruction;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class FetchExternalTasksCmd
implements Command<List<LockedExternalTask>> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String workerId;
    protected int maxResults;
    protected boolean usePriority;
    protected Map<String, TopicFetchInstruction> fetchInstructions = new HashMap<String, TopicFetchInstruction>();

    public FetchExternalTasksCmd(String workerId, int maxResults, Map<String, TopicFetchInstruction> instructions) {
        this(workerId, maxResults, instructions, false);
    }

    public FetchExternalTasksCmd(String workerId, int maxResults, Map<String, TopicFetchInstruction> instructions, boolean usePriority) {
        this.workerId = workerId;
        this.maxResults = maxResults;
        this.fetchInstructions = instructions;
        this.usePriority = usePriority;
    }

    @Override
    public List<LockedExternalTask> execute(CommandContext commandContext) {
        this.validateInput();
        for (TopicFetchInstruction instruction : this.fetchInstructions.values()) {
            instruction.ensureVariablesInitialized();
        }
        List<ExternalTaskEntity> externalTasks = commandContext.getExternalTaskManager().selectExternalTasksForTopics(new ArrayList<TopicFetchInstruction>(this.fetchInstructions.values()), this.maxResults, this.usePriority);
        ArrayList<LockedExternalTask> result = new ArrayList<LockedExternalTask>();
        for (ExternalTaskEntity entity : externalTasks) {
            TopicFetchInstruction fetchInstruction = this.fetchInstructions.get(entity.getTopicName());
            ExecutionEntity execution = entity.getExecution(false);
            if (execution != null) {
                entity.lock(this.workerId, fetchInstruction.getLockDuration());
                LockedExternalTaskImpl resultTask = LockedExternalTaskImpl.fromEntity(entity, fetchInstruction.getVariablesToFetch(), fetchInstruction.isLocalVariables(), fetchInstruction.isDeserializeVariables(), fetchInstruction.isIncludeExtensionProperties());
                result.add(resultTask);
                continue;
            }
            LOG.logTaskWithoutExecution(this.workerId);
        }
        this.filterOnOptimisticLockingFailure(commandContext, result);
        return result;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    protected void filterOnOptimisticLockingFailure(CommandContext commandContext, final List<LockedExternalTask> tasks) {
        commandContext.getDbEntityManager().registerOptimisticLockingListener(new OptimisticLockingListener(){

            @Override
            public Class<? extends DbEntity> getEntityType() {
                return ExternalTaskEntity.class;
            }

            @Override
            public OptimisticLockingResult failedOperation(DbOperation operation) {
                if (operation instanceof DbEntityOperation) {
                    DbEntityOperation dbEntityOperation = (DbEntityOperation)operation;
                    DbEntity dbEntity = dbEntityOperation.getEntity();
                    boolean failedOperationEntityInList = false;
                    Iterator it = tasks.iterator();
                    while (it.hasNext()) {
                        LockedExternalTask resultTask = (LockedExternalTask)it.next();
                        if (!resultTask.getId().equals(dbEntity.getId())) continue;
                        it.remove();
                        failedOperationEntityInList = true;
                        break;
                    }
                    if (!failedOperationEntityInList) {
                        return OptimisticLockingResult.THROW;
                    }
                    return OptimisticLockingResult.IGNORE;
                }
                return OptimisticLockingResult.THROW;
            }
        });
    }

    protected void validateInput() {
        EnsureUtil.ensureNotNull("workerId", (Object)this.workerId);
        EnsureUtil.ensureGreaterThanOrEqual("maxResults", this.maxResults, 0L);
        for (TopicFetchInstruction instruction : this.fetchInstructions.values()) {
            EnsureUtil.ensureNotNull("topicName", (Object)instruction.getTopicName());
            EnsureUtil.ensurePositive("lockTime", instruction.getLockDuration());
        }
    }
}

