/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.factory;

import com.dtflys.forest.Forest;
import com.dtflys.forest.config.ForestConfiguration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.config.SmsSqlConfig;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.utils.JDBCTool;

public class BeanFactory {
    private static DelayedTime delayedTime;
    private static Executor executor;
    private static SmsConfig smsConfig;
    private static JDBCTool jdbcTool;
    private static SmsSqlConfig smsSqlConfig;
    private static ForestConfiguration forestConfiguration;
    private static final BeanFactory beanFactory;

    private BeanFactory() {
    }

    public static ForestConfiguration getForestConfiguration() {
        if (forestConfiguration == null) {
            forestConfiguration = Forest.config().setBackendName("httpclient").setLogEnabled(BeanFactory.getSmsConfig().getHttpLog().booleanValue());
        }
        return forestConfiguration;
    }

    public static DelayedTime getDelayedTime() {
        if (delayedTime == null) {
            delayedTime = new DelayedTime();
        }
        return delayedTime;
    }

    public static Executor setExecutor(SmsConfig config) {
        if (executor == null) {
            ThreadPoolExecutor ex = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaxPoolSize(), config.getQueueCapacity().intValue(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(config.getMaxPoolSize()));
            ex.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            executor = ex;
        }
        return executor;
    }

    public static Executor getExecutor() {
        return executor;
    }

    public static SmsConfig getSmsConfig() {
        if (smsConfig == null) {
            smsConfig = new SmsConfig();
        }
        return smsConfig;
    }

    public static SmsSqlConfig getSmsSqlConfig() {
        if (smsSqlConfig == null) {
            smsSqlConfig = new SmsSqlConfig();
        }
        return smsSqlConfig;
    }

    public static JDBCTool getJDBCTool() {
        if (jdbcTool == null) {
            jdbcTool = new JDBCTool(BeanFactory.getSmsSqlConfig());
        }
        return jdbcTool;
    }

    static {
        beanFactory = new BeanFactory();
    }
}

