/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.ctyun.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.ctyun.config.CtyunConfig;
import org.dromara.sms4j.ctyun.service.CtyunSmsImpl;
import org.dromara.sms4j.provider.base.BaseProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtyunFactory
implements BaseProviderFactory<CtyunSmsImpl, CtyunConfig> {
    private static final Logger log = LoggerFactory.getLogger(CtyunFactory.class);
    private static CtyunSmsImpl ctyunSms;
    private static final CtyunFactory INSTANCE;

    private CtyunFactory() {
    }

    public static CtyunFactory instance() {
        return INSTANCE;
    }

    @Override
    public CtyunSmsImpl createSms(CtyunConfig ctyunConfig) {
        if (ctyunSms == null) {
            ctyunSms = this.createMultitonSms(ctyunConfig);
        }
        return ctyunSms;
    }

    @Override
    public CtyunSmsImpl createMultitonSms(CtyunConfig ctyunConfig) {
        return new CtyunSmsImpl(ctyunConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public CtyunSmsImpl refresh(CtyunConfig ctyunConfig) {
        ctyunSms = new CtyunSmsImpl(ctyunConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return ctyunSms;
    }

    @Override
    public CtyunConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(CtyunConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new CtyunFactory();
    }

    private static final class ConfigHolder {
        private static CtyunConfig config = CtyunConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

