/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.tencent.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.provider.base.BaseProviderFactory;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.dromara.sms4j.tencent.service.TencentSmsImpl;

public class TencentFactory
implements BaseProviderFactory<TencentSmsImpl, TencentConfig> {
    private static TencentSmsImpl tencentSms;
    private static final TencentFactory INSTANCE;

    private TencentFactory() {
    }

    public static TencentFactory instance() {
        return INSTANCE;
    }

    @Override
    public TencentSmsImpl createSms(TencentConfig tencentConfig) {
        if (tencentSms == null) {
            tencentSms = this.createMultitonSms(tencentConfig);
        }
        return tencentSms;
    }

    @Override
    public TencentSmsImpl createMultitonSms(TencentConfig tencentConfig) {
        return new TencentSmsImpl(tencentConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public TencentSmsImpl refresh(TencentConfig tencentConfig) {
        tencentSms = new TencentSmsImpl(tencentConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return tencentSms;
    }

    @Override
    public TencentConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(TencentConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new TencentFactory();
    }

    private static final class ConfigHolder {
        private static TencentConfig config = TencentConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

