/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.unisms.core;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONUtil;
import com.dtflys.forest.config.ForestConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.unisms.core.MapKeyComparator;
import org.dromara.sms4j.unisms.core.UniResponse;

public class UniClient {
    public static final String USER_AGENT = "uni-java-sdk/0.0.4";
    private final ForestConfiguration http = BeanFactory.getForestConfiguration();
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String endpoint;
    private final String signingAlgorithm;

    protected UniClient(Builder b) {
        this.accessKeyId = b.accessKeyId;
        this.accessKeySecret = b.accessKeySecret;
        this.endpoint = b.endpoint;
        this.signingAlgorithm = b.signingAlgorithm;
    }

    private static String getSignature(String message, String secretKey) {
        try {
            HMac hMac = new HMac(HmacAlgorithm.HmacSHA256, secretKey.getBytes());
            byte[] bytes = hMac.digest(message.getBytes());
            return Base64.encode((byte[])bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String queryStringify(Map<String, Object> params) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(new MapKeyComparator());
        sortedMap.putAll(params);
        StringBuilder sb = new StringBuilder();
        Iterator iter = sortedMap.entrySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            Map.Entry entry = iter.next();
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    private Map<String, Object> sign(Map<String, Object> query) {
        if (this.accessKeySecret != null) {
            query.put("algorithm", this.signingAlgorithm);
            query.put("timestamp", new Date().getTime());
            query.put("nonce", UUID.randomUUID().toString().replaceAll("-", ""));
            String strToSign = UniClient.queryStringify(query);
            query.put("signature", UniClient.getSignature(strToSign, this.accessKeySecret));
        }
        return query;
    }

    public UniResponse request(String action, Map<String, Object> data) throws SmsBlendException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("action", action);
        query.put("accessKeyId", this.accessKeyId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", USER_AGENT);
        headers.put("Content-Type", "application/json;charset=utf-8");
        headers.put("Accept", "application/json");
        String str = this.http.post(this.endpoint).addHeader(headers).addQuery(this.sign(query)).addBody(JSONUtil.toJsonStr(data)).successWhen((req, res) -> res.noException() && res.statusIsNot(500)).onError((ex, req, res) -> {
            throw new SmsBlendException(ex.getMessage());
        }).executeAsString();
        return new UniResponse(JSONUtil.parseObj((String)str));
    }

    public static class Builder {
        private String accessKeyId;
        private String accessKeySecret;
        private String endpoint;
        private String signingAlgorithm;

        public Builder(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public Builder(String accessKeyId, String accessKeySecret) {
            this.accessKeyId = accessKeyId;
            this.accessKeySecret = accessKeySecret;
        }

        public Builder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public UniClient build() {
            return new UniClient(this);
        }
    }
}

