/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.ctyun.service;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.ctyun.config.CtyunConfig;
import org.dromara.sms4j.ctyun.utils.CtyunUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtyunSmsImpl
extends AbstractSmsBlend<CtyunConfig> {
    private static final Logger log = LoggerFactory.getLogger(CtyunSmsImpl.class);
    private int retry = 0;

    public CtyunSmsImpl(CtyunConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public CtyunSmsImpl(CtyunConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "ctyun";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((CtyunConfig)this.getConfig()).getTemplateName(), message);
        return this.sendMessage(phone, ((CtyunConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((CtyunConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(phone, messageStr, templateId);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((CtyunConfig)this.getConfig()).getTemplateName(), message);
        return this.massTexting(phones, ((CtyunConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        String messageStr = JSONUtil.toJsonStr(messages);
        return this.getSmsResponse(SmsUtils.arrayToString(phones), messageStr, templateId);
    }

    private SmsResponse getSmsResponse(String phone, String message, String templateId) {
        SmsResponse smsResponse;
        String paramStr;
        String requestUrl;
        try {
            requestUrl = ((CtyunConfig)this.getConfig()).getRequestUrl();
            paramStr = CtyunUtils.generateParamJsonStr((CtyunConfig)this.getConfig(), phone, message, templateId);
        }
        catch (Exception e) {
            log.error("ctyun send message error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        log.debug("requestUrl {}", (Object)requestUrl);
        try {
            smsResponse = this.getResponse(this.http.postJson(requestUrl, CtyunUtils.signHeader(paramStr, ((CtyunConfig)this.getConfig()).getAccessKeyId(), ((CtyunConfig)this.getConfig()).getAccessKeySecret()), paramStr));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((CtyunConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message, templateId);
    }

    private SmsResponse requestRetry(String phone, String message, String templateId) {
        this.http.safeSleep(((CtyunConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.getSmsResponse(phone, message, templateId);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("OK".equals(resJson.getStr((Object)"code")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

