/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.baidu.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.baidu.config.BaiduConfig;
import org.dromara.sms4j.baidu.utils.BaiduUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduSmsImpl
extends AbstractSmsBlend<BaiduConfig> {
    private static final Logger log = LoggerFactory.getLogger(BaiduSmsImpl.class);
    private int retry = 0;

    public BaiduSmsImpl(BaiduConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public BaiduSmsImpl(BaiduConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "baidu";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((BaiduConfig)this.getConfig()).getTemplateName(), message);
        return this.sendMessage(phone, ((BaiduConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((BaiduConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponse(phone, templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((BaiduConfig)this.getConfig()).getTemplateName(), message);
        return this.massTexting(phones, ((BaiduConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponse(SmsUtils.addCodePrefixIfNot(phones), templateId, messages);
    }

    private SmsResponse getSmsResponse(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.getSmsResponseWithClientToken(phone, templateId, messages, null);
    }

    private void checkClientToken(String clientToken) {
        if (StrUtil.isBlank((CharSequence)clientToken)) {
            log.error("clientToken is required.");
            throw new SmsBlendException("clientToken is required.");
        }
    }

    public SmsResponse sendMessageWithClientToken(String phone, String message, String clientToken) {
        this.checkClientToken(clientToken);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((BaiduConfig)this.getConfig()).getTemplateName(), message);
        return this.sendMessageWithClientToken(phone, ((BaiduConfig)this.getConfig()).getTemplateId(), map, clientToken);
    }

    public SmsResponse sendMessageWithClientToken(String phone, LinkedHashMap<String, String> messages, String clientToken) {
        this.checkClientToken(clientToken);
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessageWithClientToken(phone, ((BaiduConfig)this.getConfig()).getTemplateId(), messages, clientToken);
    }

    public SmsResponse sendMessageWithClientToken(String phone, String templateId, LinkedHashMap<String, String> messages, String clientToken) {
        this.checkClientToken(clientToken);
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponseWithClientToken(phone, templateId, messages, clientToken);
    }

    public SmsResponse massTextingWithClientToken(List<String> phones, String message, String clientToken) {
        this.checkClientToken(clientToken);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((BaiduConfig)this.getConfig()).getTemplateName(), message);
        return this.massTextingWithClientToken(phones, ((BaiduConfig)this.getConfig()).getTemplateId(), map, clientToken);
    }

    public SmsResponse massTextingWithClientToken(List<String> phones, String templateId, LinkedHashMap<String, String> messages, String clientToken) {
        this.checkClientToken(clientToken);
        if (CollUtil.isEmpty(messages)) {
            messages = new LinkedHashMap();
        }
        return this.getSmsResponseWithClientToken(SmsUtils.addCodePrefixIfNot(phones), templateId, messages, clientToken);
    }

    private SmsResponse getSmsResponseWithClientToken(String phone, String templateId, LinkedHashMap<String, String> messages, String clientToken) {
        SmsResponse smsResponse;
        Map<String, Object> body;
        Map<String, String> headers;
        BaiduConfig config = (BaiduConfig)this.getConfig();
        if (StrUtil.isBlank((CharSequence)config.getSignature())) {
            log.error("signatureId is required.");
            throw new SmsBlendException("signatureId is required.");
        }
        if (StrUtil.isBlank((CharSequence)templateId)) {
            log.error("template is required.");
            throw new SmsBlendException("template is required.");
        }
        if (StrUtil.isBlank((CharSequence)phone)) {
            log.error("mobile is required.");
            throw new SmsBlendException("mobile is required.");
        }
        try {
            headers = BaiduUtils.buildHeaders(config, clientToken);
            body = BaiduUtils.buildBody(phone, templateId, config.getSignature(), messages, config.getCustom(), config.getUserExtId());
        }
        catch (Exception e) {
            log.error("baidu sms buildHeaders or buildBody error", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        try {
            smsResponse = this.getResponse(this.http.postJson(config.getHost() + config.getAction(), headers, body));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry == config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, templateId, messages, clientToken);
    }

    private SmsResponse requestRetry(String phone, String templateId, LinkedHashMap<String, String> messages, String clientToken) {
        this.http.safeSleep(((BaiduConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("The SMS has been resent for the {}th time.", (Object)this.retry);
        return this.getSmsResponseWithClientToken(phone, templateId, messages, clientToken);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (boolean)"1000".equals(resJson.getStr((Object)"code")), (String)this.getConfigId());
    }
}

