/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.configration;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.comm.enums.ConfigType;
import org.dromara.sms4j.core.datainterface.SmsReadConfig;
import org.dromara.sms4j.provider.config.BaseConfig;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.starter.config.AbstractMultiConfig;
import org.dromara.sms4j.starter.config.AlibabaMultiConfig;
import org.dromara.sms4j.starter.config.CloopenMultiConfig;
import org.dromara.sms4j.starter.config.CtyunMultiConfig;
import org.dromara.sms4j.starter.config.DingzhongMultiConfig;
import org.dromara.sms4j.starter.config.EmayMultiConfig;
import org.dromara.sms4j.starter.config.HuaweiMultiConfig;
import org.dromara.sms4j.starter.config.JdcloudMultiConfig;
import org.dromara.sms4j.starter.config.LianluMultiConfig;
import org.dromara.sms4j.starter.config.NeteaseMultiConfig;
import org.dromara.sms4j.starter.config.QiniuMultiConfig;
import org.dromara.sms4j.starter.config.TencentMultiConfig;
import org.dromara.sms4j.starter.config.UnismsMultiConfig;
import org.dromara.sms4j.starter.config.YunpianMultiConfig;
import org.dromara.sms4j.starter.config.ZhutongMultiConfig;
import org.dromara.sms4j.starter.configration.SmsBlendsInitializer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={AlibabaMultiConfig.class, CloopenMultiConfig.class, CtyunMultiConfig.class, DingzhongMultiConfig.class, EmayMultiConfig.class, HuaweiMultiConfig.class, JdcloudMultiConfig.class, LianluMultiConfig.class, NeteaseMultiConfig.class, QiniuMultiConfig.class, TencentMultiConfig.class, UnismsMultiConfig.class, YunpianMultiConfig.class, ZhutongMultiConfig.class})
public class SupplierConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="sms", name={"config-type"}, havingValue="yaml")
    private Map<String, Map<String, Object>> blends(List<AbstractMultiConfig<?>> blends) {
        HashMap<String, Map<String, Object>> blendsMap = new HashMap<String, Map<String, Object>>();
        for (AbstractMultiConfig<?> blend : blends) {
            Field[] declaredFields = blend.getClass().getDeclaredFields();
            Optional<Field> first = Arrays.stream(declaredFields).filter(field -> field.getType().isAssignableFrom(Map.class)).findFirst();
            if (!first.isPresent()) continue;
            Field field2 = first.get();
            field2.setAccessible(Boolean.TRUE);
            Map configMap = (Map)field2.get(blend);
            if (Objects.isNull(configMap)) continue;
            for (String configId : configMap.keySet()) {
                BaseConfig config = (BaseConfig)configMap.get(configId);
                Map fieldConfigMap = (Map)JSONUtil.parseObj((Object)config).toBean((TypeReference)new TypeReference<Map<String, Object>>(){});
                blendsMap.put(configId, fieldConfigMap);
            }
        }
        return blendsMap;
    }

    @Bean
    @ConditionalOnBean(value={SmsConfig.class})
    protected List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList(Map<String, Map<String, Object>> blends, SmsConfig smsConfig) {
        ArrayList<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList = new ArrayList<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>>();
        if (ConfigType.YAML.equals((Object)smsConfig.getConfigType())) {
            for (String configId : blends.keySet()) {
                Map<String, Object> configMap = blends.get(configId);
                Object factoryPath = configMap.get("factory");
                if (!ObjectUtil.isNotEmpty((Object)factoryPath)) continue;
                Class<?> newClass = Class.forName(factoryPath.toString());
                BaseProviderFactory factory = (BaseProviderFactory)newClass.newInstance();
                factoryList.add((BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>)factory);
            }
        }
        return factoryList;
    }

    @Bean
    protected SmsBlendsInitializer smsBlendsInitializer(List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList, SmsConfig smsConfig, Map<String, Map<String, Object>> blends, ObjectProvider<SmsReadConfig> extendsSmsConfigs) {
        return new SmsBlendsInitializer(factoryList, smsConfig, blends, extendsSmsConfigs);
    }
}

