/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.util.Optional;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.Zstd;

class NoopNativeAccess
implements NativeAccess {
    private static final Logger logger = LogManager.getLogger(NativeAccess.class);

    NoopNativeAccess() {
    }

    @Override
    public boolean definitelyRunningAsRoot() {
        logger.warn("Cannot check if running as root because native access is not available");
        return false;
    }

    @Override
    public ProcessLimits getProcessLimits() {
        logger.warn("Cannot get process limits because native access is not available");
        return new ProcessLimits(-1L, -1L, -1L);
    }

    @Override
    public void tryLockMemory() {
        logger.warn("Cannot lock memory because native access is not available");
    }

    @Override
    public boolean isMemoryLocked() {
        return false;
    }

    @Override
    public Systemd systemd() {
        logger.warn("Cannot get systemd access because native access is not available");
        return null;
    }

    @Override
    public Zstd getZstd() {
        logger.warn("cannot compress with zstd because native access is not available");
        return null;
    }

    @Override
    public CloseableByteBuffer newBuffer(int len) {
        logger.warn("cannot allocate buffer because native access is not available");
        return null;
    }

    @Override
    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions() {
        logger.warn("cannot get vector distance because native access is not available");
        return Optional.empty();
    }
}

