/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.lang.management.ManagementFactory;
import java.util.Optional;
import org.elasticsearch.nativeaccess.AbstractNativeAccess;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.WindowsFunctions;
import org.elasticsearch.nativeaccess.lib.Kernel32Library;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;

class WindowsNativeAccess
extends AbstractNativeAccess {
    public static final int PAGE_NOACCESS = 1;
    public static final int PAGE_GUARD = 256;
    public static final int MEM_COMMIT = 4096;
    private final Kernel32Library kernel;
    private final WindowsFunctions windowsFunctions;

    WindowsNativeAccess(NativeLibraryProvider libraryProvider) {
        super("Windows", libraryProvider);
        this.kernel = libraryProvider.getLibrary(Kernel32Library.class);
        this.windowsFunctions = new WindowsFunctions(this.kernel);
    }

    @Override
    public boolean definitelyRunningAsRoot() {
        return false;
    }

    @Override
    public void tryLockMemory() {
        long size;
        Kernel32Library.Handle process = this.kernel.GetCurrentProcess();
        if (!this.kernel.SetProcessWorkingSetSize(process, size = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getInit() + 0x100000L, size)) {
            logger.warn("Unable to lock JVM memory. Failed to set working set size. Error code {}", new Object[]{this.kernel.GetLastError()});
        } else {
            Kernel32Library.MemoryBasicInformation memInfo = this.kernel.newMemoryBasicInformation();
            Kernel32Library.Address address = memInfo.BaseAddress();
            while (this.kernel.VirtualQueryEx(process, address, memInfo) != 0) {
                boolean lockable;
                boolean bl = lockable = memInfo.State() == 4096L && (memInfo.Protect() & 1L) != 1L && (memInfo.Protect() & 0x100L) != 256L;
                if (lockable) {
                    this.kernel.VirtualLock(memInfo.BaseAddress(), memInfo.RegionSize());
                }
                address = address.add(memInfo.RegionSize());
            }
            this.isMemoryLocked = true;
        }
    }

    @Override
    public ProcessLimits getProcessLimits() {
        return new ProcessLimits(-1L, -1L, -1L);
    }

    @Override
    public WindowsFunctions getWindowsFunctions() {
        return this.windowsFunctions;
    }

    @Override
    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions() {
        return Optional.empty();
    }
}

