/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Definitions"}, description="Manage Event Definitions", authorizations={@Authorization(value="basicAuth")})
public class EventDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @ApiOperation(value="Get an event definition resource content", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both event definition and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested event definition was not found or there is no resource with the given id present in the case definition. The status-description contains additional information.")})
    @GetMapping(value={"/event-registry-repository/event-definitions/{eventDefinitionId}/resourcedata"})
    public byte[] getEventDefinitionResource(@ApiParam(name="eventDefinitionId") @PathVariable String eventDefinitionId, HttpServletResponse response) {
        EventDefinition eventDefinition = this.getEventDefinitionFromRequest(eventDefinitionId);
        return this.getDeploymentResourceData(eventDefinition.getDeploymentId(), eventDefinition.getResourceName(), response);
    }

    protected EventDefinition getEventDefinitionFromRequest(String eventDefinitionId) {
        EventDefinition eventDefinition = (EventDefinition)this.repositoryService.createEventDefinitionQuery().eventDefinitionId(eventDefinitionId).singleResult();
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find an event definition with id '" + eventDefinitionId + "'.", EventDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessEventDefinitionById(eventDefinition);
        }
        return eventDefinition;
    }
}

