/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

public enum OS {
    DARWIN("Darwin", false),
    LINUX("Linux", true),
    SOLARIS("Solaris", true),
    WINDOWS("Windows", false);

    public final String className;
    public final boolean hasProcFS;
    private static final OS current;

    private OS(String className, boolean hasProcFS) {
        this.className = className;
        this.hasProcFS = hasProcFS;
    }

    public String asPackageName() {
        return this.name().toLowerCase();
    }

    public boolean isCurrent() {
        return OS.getCurrent() == this;
    }

    private static OS findCurrent() {
        String name = System.getProperty("os.name");
        if (name.equals("Linux")) {
            return LINUX;
        }
        if (name.equals("SunOS")) {
            return SOLARIS;
        }
        if (name.equals("Mac OS X") || name.equals("Darwin")) {
            return DARWIN;
        }
        if (name.contains("Windows")) {
            return WINDOWS;
        }
        throw new IllegalArgumentException("unknown OS: " + name);
    }

    public static OS getCurrent() {
        return current;
    }

    static {
        current = OS.findCurrent();
    }
}

