/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.LLVMToolchain;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public abstract class CCLinkerInvocation
implements LinkerInvocation {
    protected final List<String> additionalPreOptions = new ArrayList<String>();
    protected final List<String> nativeLinkerOptions = new ArrayList<String>();
    protected final List<Path> inputFilenames = new ArrayList<Path>();
    protected final List<String> rpaths = new ArrayList<String>();
    protected final List<String> libpaths = new ArrayList<String>();
    protected final List<String> libs = new ArrayList<String>();
    protected final AbstractImage.NativeImageKind imageKind;
    protected final NativeLibraries nativeLibs;
    private final List<ObjectFile.Symbol> imageSymbols;
    protected Path tempDirectory;
    protected Path outputFile;

    protected CCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> imageSymbols) {
        this.imageKind = imageKind;
        this.nativeLibs = nativeLibs;
        this.imageSymbols = imageSymbols;
    }

    abstract String getSymbolName(ObjectFile.Symbol var1);

    @Override
    public List<String> getImageSymbols(boolean onlyGlobal) {
        Stream<Object> stream = this.imageSymbols.stream();
        if (onlyGlobal) {
            Set<String> globalHiddenSymbols = CGlobalDataFeature.singleton().getGlobalHiddenSymbols();
            stream = stream.filter(symbol -> symbol.isGlobal() && !globalHiddenSymbols.contains(symbol.getName()));
        }
        if (!SubstrateOptions.useLLVMBackend()) {
            stream = stream.filter(ObjectFile.Symbol::isDefined);
        }
        return stream.map(this::getSymbolName).collect(Collectors.toList());
    }

    @Override
    public List<Path> getInputFiles() {
        return Collections.unmodifiableList(this.inputFilenames);
    }

    @Override
    public void addInputFile(Path filename) {
        this.inputFilenames.add(filename);
    }

    @Override
    public void addInputFile(int index, Path filename) {
        this.inputFilenames.add(index, filename);
    }

    @Override
    public List<String> getLibPaths() {
        return Collections.unmodifiableList(this.libpaths);
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(this.libpaths.size(), libPath);
    }

    @Override
    public void addLibPath(int index, String libPath) {
        if (!libPath.isEmpty()) {
            this.libpaths.add(index, libPath);
        }
    }

    @Override
    public List<String> getRPaths() {
        return Collections.unmodifiableList(this.rpaths);
    }

    @Override
    public void addRPath(String rPath) {
        this.addRPath(this.rpaths.size(), rPath);
    }

    @Override
    public void addRPath(int index, String rPath) {
        if (!rPath.isEmpty()) {
            this.rpaths.add(rPath);
        }
    }

    @Override
    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(Path out) {
        this.outputFile = out;
    }

    public void setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    @Override
    public Path getTempDirectory() {
        return this.tempDirectory;
    }

    @Override
    public List<String> getLinkedLibraries() {
        return Collections.unmodifiableList(this.libs);
    }

    @Override
    public void addLinkedLibrary(String libname) {
        this.libs.add(libname);
    }

    @Override
    public void addLinkedLibrary(int index, String libname) {
        this.libs.add(index, libname);
    }

    protected List<String> getCompilerCommand(List<String> options) {
        Path[] inputPaths = (Path[])this.inputFilenames.stream().map(path -> path.startsWith(this.tempDirectory) ? this.tempDirectory.relativize((Path)path) : path).toArray(Path[]::new);
        return ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(options, this.outputFile, inputPaths);
    }

    protected abstract void setOutputKind(List<String> var1);

    @Override
    public List<String> getCommand() {
        List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
        ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
        this.setOutputKind(cmd);
        cmd.add("-v");
        for (String libpath : this.libpaths) {
            cmd.add("-L" + libpath);
        }
        for (String rpath : this.rpaths) {
            cmd.add("-Wl,-rpath");
            cmd.add("-Wl," + rpath);
        }
        cmd.addAll(this.getLibrariesCommand());
        cmd.addAll(this.getNativeLinkerOptions());
        return cmd;
    }

    protected List<String> getLibrariesCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        for (String lib : this.libs) {
            if (lib.startsWith("-")) {
                cmd.add("-Wl," + lib.replace(" ", ","));
                continue;
            }
            cmd.add("-l" + lib);
        }
        return cmd;
    }

    @Override
    public void addNativeLinkerOption(String option) {
        this.nativeLinkerOptions.add(option);
    }

    protected List<String> getNativeLinkerOptions() {
        return Stream.of(this.nativeLinkerOptions, Options.NativeLinkerOption.getValue().values()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static LinkerInvocation getLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, Path[] inputFiles, Path outputDirectory, Path tempDirectory, String imageName, List<ObjectFile.Symbol> symbols) {
        CCLinkerInvocation inv;
        switch (ObjectFile.getNativeFormat()) {
            case MACH_O: {
                inv = new DarwinCCLinkerInvocation(imageKind, nativeLibs, symbols);
                break;
            }
            case PECOFF: {
                inv = new WindowsCCLinkerInvocation(imageKind, nativeLibs, symbols, imageName);
                break;
            }
            default: {
                inv = new BinutilsCCLinkerInvocation(imageKind, nativeLibs, symbols);
            }
        }
        Path outputFile = outputDirectory.resolve(imageName + imageKind.getFilenameSuffix());
        UserError.guarantee(!Files.isDirectory(outputFile, new LinkOption[0]), "Cannot write image to %s. Path exists as directory. (Use -H:Name=<image name>)", outputFile);
        inv.setOutputFile(outputFile);
        inv.setTempDirectory(tempDirectory);
        inv.addLibPath(tempDirectory.toString());
        for (String libraryPath : nativeLibs.getLibraryPaths()) {
            inv.addLibPath(libraryPath);
        }
        for (String rPath : OptionUtils.flatten(",", SubstrateOptions.LinkerRPath.getValue())) {
            inv.addRPath(rPath);
        }
        Collection libraries = nativeLibs.getLibraries();
        if (Platform.includedIn(Platform.LINUX.class) && ((LibCBase)ImageSingletons.lookup(LibCBase.class)).getName().equals("bionic")) {
            libraries = libraries.stream().filter(library -> !Arrays.asList("pthread", "rt").contains(library)).collect(Collectors.toList());
        }
        libraries.forEach(inv::addLinkedLibrary);
        for (Path filename : inputFiles) {
            inv.addInputFile(filename);
        }
        for (Path staticLibraryPath : nativeLibs.getStaticLibraries()) {
            inv.addInputFile(staticLibraryPath);
        }
        return inv;
    }

    private static class WindowsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final String imageName;

        WindowsCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols, String imageName) {
            super(imageKind, nativeLibs, symbols);
            this.imageName = imageName;
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case EXECUTABLE: 
                case STATIC_EXECUTABLE: {
                    cmd.add("/MD");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("/MD");
                    cmd.add("/LD");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return symbol.getName();
        }

        @Override
        public List<String> getCommand() {
            List<String> compilerCmd = this.getCompilerCommand(this.additionalPreOptions);
            ArrayList<String> cmd = new ArrayList<String>(compilerCmd);
            this.setOutputKind(cmd);
            for (Path staticLibrary : this.nativeLibs.getStaticLibraries()) {
                cmd.add(staticLibrary.toString());
            }
            cmd.add("/link");
            cmd.add("/INCREMENTAL:NO");
            cmd.add("/NODEFAULTLIB:LIBCMT");
            cmd.add("/FILEALIGN:4096");
            cmd.add("/IMPLIB:" + this.getTempDirectory().resolve(this.imageName + ".lib"));
            if (SubstrateOptions.GenerateDebugInfo.getValue() > 0) {
                cmd.add("/DEBUG");
                if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                    String pdbFile = this.imageName + ".pdb";
                    cmd.add("/PDB:" + this.getTempDirectory().resolve(pdbFile));
                    cmd.add("/PDBSTRIPPED:" + this.getOutputFile().resolveSibling(pdbFile));
                }
            }
            if (!SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                cmd.add("/OPT:NOREF,NOICF");
            }
            for (String libraryPath : this.nativeLibs.getLibraryPaths()) {
                cmd.add("/LIBPATH:" + libraryPath);
            }
            for (String library : this.nativeLibs.getLibraries()) {
                cmd.add(library + ".lib");
            }
            cmd.add("advapi32.lib");
            cmd.add("ws2_32.lib");
            cmd.add("secur32.lib");
            cmd.add("iphlpapi.lib");
            cmd.add("userenv.lib");
            if (SubstrateOptions.EnableWildcardExpansion.getValue().booleanValue() && this.imageKind == AbstractImage.NativeImageKind.EXECUTABLE) {
                cmd.add("setargv.obj");
            }
            cmd.addAll(this.getNativeLinkerOptions());
            return cmd;
        }
    }

    private static class DarwinCCLinkerInvocation
    extends CCLinkerInvocation {
        DarwinCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols) {
            super(imageKind, nativeLibs, symbols);
            this.setLinkerFlags(nativeLibs, false);
        }

        private void setLinkerFlags(NativeLibraries nativeLibs, boolean useFallback) {
            this.additionalPreOptions.add("-Wl,-U,___darwin_check_fd_set_overflow");
            boolean useLld = false;
            if (useFallback) {
                Path lld = LLVMToolchain.getLLVMBinDir().resolve("ld64.lld").toAbsolutePath();
                if (Files.exists(lld, new LinkOption[0])) {
                    useLld = true;
                    this.additionalPreOptions.add("-fuse-ld=" + lld);
                } else {
                    throw new RuntimeException("The Native Image build ran into a ld64 limitation. Please use ld64.lld via `gu install llvm-toolchain` and run the same command again.");
                }
            }
            if (!SubstrateOptions.useLLVMBackend() && !useLld) {
                this.additionalPreOptions.add("-Wl,-no_compact_unwind");
            }
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-dead_strip");
            }
            try {
                Path exportedSymbolsPath = nativeLibs.tempDirectory.resolve("exported_symbols.list");
                Files.write(exportedSymbolsPath, this.getImageSymbols(true), new OpenOption[0]);
                this.additionalPreOptions.add("-Wl,-exported_symbols_list");
                this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
            }
            catch (IOException e) {
                VMError.shouldNotReachHere();
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
            this.additionalPreOptions.add("-arch");
            if (Platform.includedIn(Platform.AMD64.class)) {
                this.additionalPreOptions.add("x86_64");
            } else if (Platform.includedIn(Platform.AARCH64.class)) {
                this.additionalPreOptions.add("arm64");
            }
        }

        @Override
        public List<String> getFallbackCommand() {
            this.additionalPreOptions.clear();
            this.setLinkerFlags(this.nativeLibs, true);
            return this.getCommand();
        }

        @Override
        public boolean shouldRunFallback(String message) {
            if (Platform.includedIn(Platform.AARCH64.class)) {
                return message.contains("branch out of range") || message.contains("Unable to insert branch island");
            }
            return false;
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return ((MachOSymtab.Entry)symbol).getNameInObject();
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case STATIC_EXECUTABLE: {
                    throw UserError.abort("%s does not support building static executable images.", OS.getCurrent().name());
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    if (!Platform.includedIn(Platform.DARWIN.class)) break;
                    cmd.add("-undefined");
                    cmd.add("dynamic_lookup");
                }
            }
        }
    }

    private static class BinutilsCCLinkerInvocation
    extends CCLinkerInvocation {
        private final boolean staticExecWithDynamicallyLinkLibC = SubstrateOptions.StaticExecutableWithDynamicLibC.getValue();
        private final Set<String> libCLibaries = new HashSet<String>(Arrays.asList("pthread", "dl", "rt", "m"));

        BinutilsCCLinkerInvocation(AbstractImage.NativeImageKind imageKind, NativeLibraries nativeLibs, List<ObjectFile.Symbol> symbols) {
            super(imageKind, nativeLibs, symbols);
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add("noexecstack");
            if (SubstrateOptions.ForceNoROSectionRelocations.getValue().booleanValue()) {
                this.additionalPreOptions.add("-fuse-ld=gold");
                this.additionalPreOptions.add("-Wl,--rosegment");
            }
            if (SubstrateOptions.RemoveUnusedSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,--gc-sections");
            }
            if (!SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
                try {
                    StringBuilder exportedSymbols = new StringBuilder();
                    exportedSymbols.append("{\n");
                    for (String symbol : this.getImageSymbols(true)) {
                        exportedSymbols.append('\"').append(symbol).append("\";\n");
                    }
                    exportedSymbols.append("};");
                    Path exportedSymbolsPath = nativeLibs.tempDirectory.resolve("exported_symbols.list");
                    Files.write(exportedSymbolsPath, Collections.singleton(exportedSymbols.toString()), new OpenOption[0]);
                    this.additionalPreOptions.add("-Wl,--dynamic-list");
                    this.additionalPreOptions.add("-Wl," + exportedSymbolsPath.toAbsolutePath());
                    this.additionalPreOptions.add("-Wl,--exclude-libs,ALL");
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere();
                }
            }
            if (SubstrateOptions.DeleteLocalSymbols.getValue().booleanValue()) {
                this.additionalPreOptions.add("-Wl,-x");
            }
        }

        @Override
        String getSymbolName(ObjectFile.Symbol symbol) {
            return symbol.getName();
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (this.imageKind) {
                case EXECUTABLE: {
                    break;
                }
                case STATIC_EXECUTABLE: {
                    if (this.staticExecWithDynamicallyLinkLibC) break;
                    cmd.add("-static");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        protected List<String> getLibrariesCommand() {
            ArrayList<String> cmd = new ArrayList<String>();
            for (String lib : this.libs) {
                if (this.staticExecWithDynamicallyLinkLibC) {
                    String linkingMode = this.libCLibaries.contains(lib) ? "dynamic" : "static";
                    cmd.add("-Wl,-B" + linkingMode);
                }
                cmd.add("-l" + lib);
            }
            if (this.staticExecWithDynamicallyLinkLibC) {
                cmd.add("-static-libgcc");
            }
            return cmd;
        }
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> NativeLinkerOption = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    }
}

