/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.SpecializationStatistics;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostClassCache;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostToGuestCodeCache;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.ImageBuildTimeOptions;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotEngineOptionsOptionDescriptors;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.ProcessHandlers;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotEngineImpl
extends AbstractPolyglotImpl.AbstractEngineImpl
implements PolyglotImpl.VMObject {
    static final int HOST_LANGUAGE_INDEX = 0;
    static final String HOST_LANGUAGE_ID = "host";
    static final String ENGINE_ID = "engine";
    static final String OPTION_GROUP_ENGINE = "engine";
    static final String OPTION_GROUP_LOG = "log";
    static final String OPTION_GROUP_IMAGE_BUILD_TIME = "image-build-time";
    static final String LOG_FILE_OPTION = "log.file";
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "file", "engine", "log", "image-build-time"));
    private static final Map<PolyglotEngineImpl, Void> ENGINES = Collections.synchronizedMap(new WeakHashMap());
    private static volatile boolean shutdownHookInitialized = false;
    private static final boolean DEBUG_MISSING_CLOSE = Boolean.getBoolean("polyglotimpl.DebugMissingClose");
    static final PolyglotLocals.LocalLocation[] EMPTY_LOCATIONS = new PolyglotLocals.LocalLocation[0];
    final Object lock = new Object();
    Engine creatorApi;
    Engine currentApi;
    final Object instrumentationHandler;
    final PolyglotImpl impl;
    DispatchOutputStream out;
    DispatchOutputStream err;
    InputStream in;
    final Map<String, PolyglotLanguage> idToLanguage;
    final Map<String, PolyglotLanguage> classToLanguage;
    final Map<String, Language> idToPublicLanguage;
    final Map<String, LanguageInfo> idToInternalLanguageInfo;
    final Map<String, PolyglotInstrument> idToInstrument;
    final Map<String, Instrument> idToPublicInstrument;
    final Map<String, InstrumentInfo> idToInternalInstrumentInfo;
    @CompilerDirectives.CompilationFinal
    OptionValuesImpl engineOptionValues;
    ClassLoader contextClassLoader;
    boolean boundEngine;
    boolean storeEngine;
    Handler logHandler;
    final Exception createdLocation = DEBUG_MISSING_CLOSE ? new Exception() : null;
    private final EconomicSet<PolyglotContextImpl.ContextWeakReference> contexts = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    final ReferenceQueue<PolyglotContextImpl> contextsReferenceQueue = new ReferenceQueue();
    private final AtomicReference<PolyglotContextImpl> preInitializedContext = new AtomicReference();
    PolyglotLanguage hostLanguage;
    @CompilerDirectives.CompilationFinal
    Assumption singleContext = Truffle.getRuntime().createAssumption("Single context per engine.");
    final Assumption singleThreadPerContext = Truffle.getRuntime().createAssumption("Single thread per context of an engine.");
    final Assumption noInnerContexts = Truffle.getRuntime().createAssumption("No inner contexts.");
    final Assumption customHostClassLoader = Truffle.getRuntime().createAssumption("No custom host class loader needed.");
    final Assumption neverInterrupted = Truffle.getRuntime().createAssumption("No context interrupted.");
    volatile OptionDescriptors allOptions;
    volatile boolean closed;
    private volatile CancelHandler cancelHandler;
    final Object runtimeData;
    Map<String, Level> logLevels;
    HostClassCache hostClassCache;
    private volatile Object engineLoggers;
    private volatile Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectorsSupplier;
    final int contextLength;
    private volatile PolyglotLimits.EngineLimits limits;
    final boolean conservativeContextReferences;
    private final MessageTransport messageInterceptor;
    private volatile int asynchronousStackDepth = 0;
    @CompilerDirectives.CompilationFinal
    private HostToGuestCodeCache hostToGuestCodeCache;
    final SpecializationStatistics specializationStatistics;
    Function<String, TruffleLogger> engineLoggerSupplier;
    private volatile TruffleLogger engineLogger;
    @CompilerDirectives.CompilationFinal
    volatile StableLocalLocations contextLocalLocations = new StableLocalLocations(EMPTY_LOCATIONS);
    @CompilerDirectives.CompilationFinal
    volatile StableLocalLocations contextThreadLocalLocations = new StableLocalLocations(EMPTY_LOCATIONS);
    @CompilerDirectives.CompilationFinal
    private volatile Node noLocation;
    private static final String DISABLE_PRIVILEGES_VALUE = ImageBuildTimeOptions.get("DisablePrivileges");
    private static final String[] DISABLED_PRIVILEGES = DISABLE_PRIVILEGES_VALUE.isEmpty() ? new String[]{} : DISABLE_PRIVILEGES_VALUE.split(",");
    private static final boolean ALLOW_CREATE_PROCESS;
    static final boolean ALLOW_ENVIRONMENT_ACCESS;
    static final boolean ALLOW_IO;
    private static final Object NO_ENTER;
    private static volatile PolyglotEngineImpl fallbackEngine;

    PolyglotEngineImpl(PolyglotImpl impl, DispatchOutputStream out, DispatchOutputStream err, InputStream in, OptionValuesImpl engineOptions, Map<String, Level> logLevels, PolyglotLoggers.EngineLoggerProvider engineLogger, Map<String, String> options, boolean allowExperimentalOptions, ClassLoader contextClassLoader, boolean boundEngine, boolean preInitialization, MessageTransport messageInterceptor, Handler logHandler) {
        super((AbstractPolyglotImpl)impl);
        this.messageInterceptor = messageInterceptor;
        this.impl = impl;
        this.out = out;
        this.err = err;
        this.in = in;
        this.contextClassLoader = contextClassLoader;
        this.logHandler = logHandler;
        this.logLevels = logLevels;
        this.boundEngine = boundEngine;
        this.storeEngine = EngineAccessor.RUNTIME.isStoreEnabled(engineOptions);
        LinkedHashMap<String, LanguageInfo> languageInfos = new LinkedHashMap<String, LanguageInfo>();
        this.idToLanguage = Collections.unmodifiableMap(this.initializeLanguages(languageInfos));
        this.idToInternalLanguageInfo = Collections.unmodifiableMap(languageInfos);
        this.contextLength = this.idToLanguage.size() + 1;
        LinkedHashMap<String, InstrumentInfo> instrumentInfos = new LinkedHashMap<String, InstrumentInfo>();
        this.idToInstrument = Collections.unmodifiableMap(this.initializeInstruments(instrumentInfos));
        this.idToInternalInstrumentInfo = Collections.unmodifiableMap(instrumentInfos);
        engineLogger.setEngine(this);
        this.runtimeData = EngineAccessor.RUNTIME.createRuntimeData(engineOptions, engineLogger);
        this.classToLanguage = new HashMap<String, PolyglotLanguage>();
        for (PolyglotLanguage polyglotLanguage : this.idToLanguage.values()) {
            this.classToLanguage.put(polyglotLanguage.cache.getClassName(), polyglotLanguage);
        }
        for (String string : this.idToLanguage.keySet()) {
            if (!this.idToInstrument.containsKey(string)) continue;
            throw PolyglotEngineImpl.failDuplicateId(string, this.idToLanguage.get((Object)string).cache.getClassName(), this.idToInstrument.get((Object)string).cache.getClassName());
        }
        this.engineLoggerSupplier = engineLogger;
        this.engineOptionValues = engineOptions;
        LinkedHashMap<String, Language> publicLanguages = new LinkedHashMap<String, Language>();
        for (String string : this.idToLanguage.keySet()) {
            PolyglotLanguage languageImpl = this.idToLanguage.get(string);
            if (languageImpl.cache.isInternal()) continue;
            publicLanguages.put(string, languageImpl.api);
        }
        this.idToPublicLanguage = Collections.unmodifiableMap(publicLanguages);
        LinkedHashMap<String, Instrument> linkedHashMap = new LinkedHashMap<String, Instrument>();
        for (String key : this.idToInstrument.keySet()) {
            PolyglotInstrument instrumentImpl = this.idToInstrument.get(key);
            if (instrumentImpl.cache.isInternal()) continue;
            linkedHashMap.put(key, instrumentImpl.api);
        }
        this.idToPublicInstrument = Collections.unmodifiableMap(linkedHashMap);
        this.instrumentationHandler = EngineAccessor.INSTRUMENT.createInstrumentationHandler(this, out, err, in, messageInterceptor, this.storeEngine);
        if (!boundEngine) {
            this.initializeMultiContext(null);
        }
        this.intitializeStore(false, this.storeEngine);
        HashMap<PolyglotLanguage, Map<String, String>> hashMap = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        this.parseOptions(options, hashMap, instrumentsOptions);
        this.conservativeContextReferences = this.engineOptionValues.get(PolyglotEngineOptions.UseConservativeContextReferences);
        for (PolyglotLanguage language : hashMap.keySet()) {
            language.getOptionValues().putAll((Map)hashMap.get(language), allowExperimentalOptions);
        }
        this.specializationStatistics = this.engineOptionValues.get(PolyglotEngineOptions.SpecializationStatistics) != false ? SpecializationStatistics.create() : null;
        this.notifyCreated();
        if (!preInitialization) {
            PolyglotEngineImpl.createInstruments(instrumentsOptions, allowExperimentalOptions);
            PolyglotEngineImpl.registerShutDownHook();
        }
    }

    HostToGuestCodeCache getHostToGuestCodeCache() {
        HostToGuestCodeCache cache = this.hostToGuestCodeCache;
        if (cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.hostToGuestCodeCache = cache = new HostToGuestCodeCache();
        }
        return cache;
    }

    Node getUncachedLocation() {
        Node location = this.noLocation;
        if (location == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.noLocation = location = new NoLocationNode(this);
        }
        return location;
    }

    void notifyCreated() {
        ENGINES.put(this, null);
        EngineAccessor.RUNTIME.onEngineCreate(this, this.runtimeData);
    }

    PolyglotEngineImpl(PolyglotEngineImpl prototype) {
        super((AbstractPolyglotImpl)prototype.impl);
        this.messageInterceptor = prototype.messageInterceptor;
        this.instrumentationHandler = EngineAccessor.INSTRUMENT.createInstrumentationHandler(this, EngineAccessor.INSTRUMENT.createDispatchOutput(EngineAccessor.INSTRUMENT.getOut(prototype.out)), EngineAccessor.INSTRUMENT.createDispatchOutput(EngineAccessor.INSTRUMENT.getOut(prototype.err)), prototype.in, prototype.messageInterceptor, prototype.storeEngine);
        this.impl = prototype.impl;
        this.out = prototype.out;
        this.err = prototype.err;
        this.in = prototype.in;
        this.contextClassLoader = prototype.contextClassLoader;
        this.boundEngine = prototype.boundEngine;
        this.logHandler = prototype.logHandler;
        this.runtimeData = EngineAccessor.RUNTIME.createRuntimeData(prototype.engineOptionValues, prototype.engineLoggerSupplier);
        this.engineLoggerSupplier = prototype.engineLoggerSupplier;
        LinkedHashMap<String, LanguageInfo> languageInfos = new LinkedHashMap<String, LanguageInfo>();
        this.idToLanguage = Collections.unmodifiableMap(this.initializeLanguages(languageInfos));
        this.idToInternalLanguageInfo = Collections.unmodifiableMap(languageInfos);
        this.contextLength = this.idToLanguage.size() + 1;
        LinkedHashMap<String, InstrumentInfo> instrumentInfos = new LinkedHashMap<String, InstrumentInfo>();
        this.idToInstrument = Collections.unmodifiableMap(this.initializeInstruments(instrumentInfos));
        this.idToInternalInstrumentInfo = Collections.unmodifiableMap(instrumentInfos);
        this.classToLanguage = new HashMap<String, PolyglotLanguage>();
        for (PolyglotLanguage polyglotLanguage : this.idToLanguage.values()) {
            this.classToLanguage.put(polyglotLanguage.cache.getClassName(), polyglotLanguage);
        }
        for (String string : this.idToLanguage.keySet()) {
            if (!this.idToInstrument.containsKey(string)) continue;
            throw PolyglotEngineImpl.failDuplicateId(string, this.idToLanguage.get((Object)string).cache.getClassName(), this.idToInstrument.get((Object)string).cache.getClassName());
        }
        LinkedHashMap<String, Language> publicLanguages = new LinkedHashMap<String, Language>();
        for (String string : this.idToLanguage.keySet()) {
            PolyglotLanguage languageImpl = this.idToLanguage.get(string);
            if (languageImpl.cache.isInternal()) continue;
            publicLanguages.put(string, languageImpl.api);
        }
        this.idToPublicLanguage = Collections.unmodifiableMap(publicLanguages);
        LinkedHashMap<String, Instrument> linkedHashMap = new LinkedHashMap<String, Instrument>();
        for (String key : this.idToInstrument.keySet()) {
            PolyglotInstrument instrumentImpl = this.idToInstrument.get(key);
            if (instrumentImpl.cache.isInternal()) continue;
            linkedHashMap.put(key, instrumentImpl.api);
        }
        this.idToPublicInstrument = Collections.unmodifiableMap(linkedHashMap);
        this.logLevels = prototype.logLevels;
        this.engineOptionValues = prototype.engineOptionValues.copy();
        this.conservativeContextReferences = this.engineOptionValues.get(PolyglotEngineOptions.UseConservativeContextReferences);
        if (!this.boundEngine) {
            this.initializeMultiContext(null);
        }
        this.intitializeStore(false, prototype.storeEngine);
        for (String languageId : this.idToLanguage.keySet()) {
            OptionValuesImpl prototypeOptions = prototype.idToLanguage.get(languageId).getOptionValuesIfExists();
            if (prototypeOptions == null) continue;
            prototypeOptions.copyInto(this.idToLanguage.get(languageId).getOptionValues());
        }
        this.specializationStatistics = this.engineOptionValues.get(PolyglotEngineOptions.SpecializationStatistics) != false ? SpecializationStatistics.create() : null;
        ArrayList<PolyglotInstrument> arrayList = new ArrayList<PolyglotInstrument>();
        for (String instrumentId : this.idToInstrument.keySet()) {
            OptionValuesImpl prototypeOptions = prototype.idToInstrument.get(instrumentId).getOptionValuesIfExists();
            if (prototypeOptions == null) continue;
            PolyglotInstrument instrument = this.idToInstrument.get(instrumentId);
            prototypeOptions.copyInto(instrument.getEngineOptionValues());
            arrayList.add(instrument);
        }
        PolyglotEngineImpl.ensureInstrumentsCreated(arrayList);
        PolyglotEngineImpl.registerShutDownHook();
        this.notifyCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TruffleLogger getEngineLogger() {
        TruffleLogger result = this.engineLogger;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.engineLogger;
                if (result == null) {
                    this.engineLogger = result = this.engineLoggerSupplier.apply("engine");
                }
            }
        }
        return result;
    }

    static OptionDescriptors createEngineOptionDescriptors() {
        PolyglotEngineOptionsOptionDescriptors engineOptionDescriptors = new PolyglotEngineOptionsOptionDescriptors();
        OptionDescriptors compilerOptionDescriptors = EngineAccessor.RUNTIME.getEngineOptionDescriptors();
        return OptionDescriptors.createUnion((OptionDescriptors[])new OptionDescriptors[]{engineOptionDescriptors, compilerOptionDescriptors});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<Engine> findActiveEngines() {
        Map<PolyglotEngineImpl, Void> map = ENGINES;
        synchronized (map) {
            ArrayList<Engine> engines = new ArrayList<Engine>(ENGINES.size());
            for (PolyglotEngineImpl engine : ENGINES.keySet()) {
                engines.add(engine.creatorApi);
            }
            return engines;
        }
    }

    void patch(DispatchOutputStream newOut, DispatchOutputStream newErr, InputStream newIn, OptionValuesImpl engineOptions, LogConfig newLogConfig, PolyglotLoggers.EngineLoggerProvider logSupplier, Map<String, String> newOptions, boolean newAllowExperimentalOptions, ClassLoader newContextClassLoader, boolean newBoundEngine, Handler newLogHandler) {
        CompilerAsserts.neverPartOfCompilation();
        this.out = newOut;
        this.err = newErr;
        this.in = newIn;
        this.contextClassLoader = newContextClassLoader;
        boolean wasBound = this.boundEngine;
        this.boundEngine = newBoundEngine;
        this.logHandler = newLogHandler;
        this.engineOptionValues = engineOptions;
        this.logLevels = newLogConfig.logLevels;
        boolean wasStore = this.storeEngine;
        this.storeEngine = EngineAccessor.RUNTIME.isStoreEnabled(engineOptions);
        this.engineLoggerSupplier = logSupplier;
        this.engineLogger = null;
        logSupplier.setEngine(this);
        this.intitializeStore(wasStore, this.storeEngine);
        if (wasBound && !newBoundEngine) {
            this.initializeMultiContext(null);
        }
        EngineAccessor.INSTRUMENT.patchInstrumentationHandler(this.instrumentationHandler, newOut, newErr, newIn);
        HashMap<PolyglotLanguage, Map<String, String>> languagesOptions = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        this.parseOptions(newOptions, languagesOptions, instrumentsOptions);
        EngineAccessor.RUNTIME.onEnginePatch(this.runtimeData, engineOptions, logSupplier);
        for (PolyglotLanguage language : languagesOptions.keySet()) {
            language.getOptionValues().putAll((Map)languagesOptions.get(language), newAllowExperimentalOptions);
        }
        for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
            instrument.getEngineOptionValues().putAll((Map)instrumentsOptions.get(instrument), newAllowExperimentalOptions);
        }
        PolyglotEngineImpl.registerShutDownHook();
    }

    static Handler createLogHandler(LogConfig logConfig, DispatchOutputStream errDispatchOutputStream) {
        if (logConfig.logFile != null) {
            if (ALLOW_IO) {
                return PolyglotLoggers.getFileHandler(logConfig.logFile);
            }
            throw PolyglotEngineException.illegalState("The `log.file` option is not allowed when the allowIO() privilege is removed at image build time.");
        }
        return PolyglotLoggers.createDefaultHandler(EngineAccessor.INSTRUMENT.getOut(errDispatchOutputStream));
    }

    private static void createInstruments(Map<PolyglotInstrument, Map<String, String>> instrumentsOptions, boolean allowExperimentalOptions) {
        for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
            instrument.getEngineOptionValues().putAll(instrumentsOptions.get(instrument), allowExperimentalOptions);
        }
        PolyglotEngineImpl.ensureInstrumentsCreated(instrumentsOptions.keySet());
    }

    static void ensureInstrumentsCreated(Collection<? extends PolyglotInstrument> instruments) {
        for (PolyglotInstrument polyglotInstrument : instruments) {
            polyglotInstrument.ensureCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerShutDownHook() {
        if (!shutdownHookInitialized) {
            Map<PolyglotEngineImpl, Void> map = ENGINES;
            synchronized (map) {
                if (!shutdownHookInitialized) {
                    shutdownHookInitialized = true;
                    Runtime.getRuntime().addShutdownHook(new Thread(new PolyglotShutDownHook()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeMultiContext(PolyglotContextImpl existingContext) {
        Object object = this.lock;
        synchronized (object) {
            if (this.singleContext.isValid()) {
                this.singleContext.invalidate("More than one context introduced.");
                if (existingContext != null) {
                    for (PolyglotLanguageContext context : existingContext.contexts) {
                        if (!context.isInitialized()) continue;
                        context.getLanguageInstance().ensureMultiContextInitialized();
                    }
                }
                for (PolyglotLanguage lang : this.idToLanguage.values()) {
                    lang.profile.prepareForMultiContext();
                }
            }
        }
    }

    static void parseEngineOptions(Map<String, String> allOptions, Map<String, String> engineOptions, LogConfig logOptions) {
        Iterator<Map.Entry<String, String>> iterator = allOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            String group = PolyglotEngineImpl.parseOptionGroup(key);
            if (group.equals("engine")) {
                engineOptions.put(entry.getKey(), entry.getValue());
                iterator.remove();
                continue;
            }
            if (!group.equals(OPTION_GROUP_LOG)) continue;
            if (LOG_FILE_OPTION.equals(key)) {
                logOptions.logFile = value;
            } else {
                logOptions.logLevels.put(PolyglotEngineImpl.parseLoggerName(key), Level.parse(value));
            }
            iterator.remove();
        }
    }

    private void parseOptions(Map<String, String> options, Map<PolyglotLanguage, Map<String, String>> languagesOptions, Map<PolyglotInstrument, Map<String, String>> instrumentsOptions) {
        for (String key : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(key);
            String value = options.get(key);
            PolyglotLanguage language = this.idToLanguage.get(group);
            if (language != null && !language.cache.isInternal()) {
                Map<String, String> languageOptions = languagesOptions.get(language);
                if (languageOptions == null) {
                    languageOptions = new HashMap<String, String>();
                    languagesOptions.put(language, languageOptions);
                }
                languageOptions.put(key, value);
                continue;
            }
            PolyglotInstrument instrument = this.idToInstrument.get(group);
            if (instrument != null && !instrument.cache.isInternal()) {
                Map<String, String> instrumentOptions = instrumentsOptions.get(instrument);
                if (instrumentOptions == null) {
                    instrumentOptions = new HashMap<String, String>();
                    instrumentsOptions.put(instrument, instrumentOptions);
                }
                instrumentOptions.put(key, value);
                continue;
            }
            switch (group) {
                case "engine": 
                case "log": {
                    throw new AssertionError((Object)"Log or engine options should already be parsed.");
                }
                case "image-build-time": {
                    throw PolyglotEngineException.illegalArgument("Image build-time option '" + key + "' cannot be set at runtime");
                }
            }
            throw OptionValuesImpl.failNotFound(this.getAllOptions(), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readOptionsFromSystemProperties(Map<String, String> options) {
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            for (Object systemKey : properties.keySet()) {
                String optionKey;
                String key;
                if ("polyglot.engine.AllowExperimentalOptions".equals(systemKey) || !(key = (String)systemKey).startsWith("polyglot.") || (optionKey = key.substring("polyglot.".length())).startsWith(OPTION_GROUP_IMAGE_BUILD_TIME) || options.containsKey(optionKey)) continue;
                options.put(optionKey, System.getProperty(key));
            }
        }
        return options;
    }

    static String parseOptionGroup(String key) {
        int groupIndex = key.indexOf(46);
        String group = groupIndex != -1 ? key.substring(0, groupIndex) : key;
        return group;
    }

    static String parseLoggerName(String optionKey) {
        int end;
        String prefix = "log.";
        String suffix = ".level";
        if (!optionKey.startsWith("log.") || !optionKey.endsWith(".level")) {
            throw PolyglotEngineException.illegalArgument(optionKey);
        }
        int start = "log.".length();
        return start < (end = optionKey.length() - ".level".length()) ? optionKey.substring(start, end) : "";
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this;
    }

    PolyglotLanguage findLanguage(PolyglotLanguageContext accessingLanguage, String languageId, String mimeType, boolean failIfNotFound, boolean allowInternalAndDependent) {
        Map<String, LanguageInfo> languages;
        assert (languageId != null || mimeType != null) : Objects.toString(languageId) + ", " + Objects.toString(mimeType);
        if (accessingLanguage != null) {
            languages = accessingLanguage.getAccessibleLanguages(allowInternalAndDependent);
        } else {
            assert (allowInternalAndDependent) : "non internal access is not yet supported for instrument lookups";
            languages = this.idToInternalLanguageInfo;
        }
        LanguageInfo foundLanguage = null;
        if (languageId != null) {
            foundLanguage = languages.get(languageId);
        }
        if (mimeType != null && foundLanguage == null && (foundLanguage = languages.get(mimeType)) == null) {
            for (LanguageInfo searchLanguage : languages.values()) {
                if (!searchLanguage.getMimeTypes().contains(mimeType)) continue;
                foundLanguage = searchLanguage;
                break;
            }
        }
        assert (allowInternalAndDependent || foundLanguage == null || !foundLanguage.isInternal() && accessingLanguage.isPolyglotEvalAllowed(languageId));
        if (foundLanguage != null) {
            return (PolyglotLanguage)EngineAccessor.NODES.getPolyglotLanguage(foundLanguage);
        }
        if (failIfNotFound) {
            if (languageId != null) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (LanguageInfo language : languages.values()) {
                    ids.add(language.getId());
                }
                throw PolyglotEngineException.illegalState("No language for id " + languageId + " found. Supported languages are: " + ids);
            }
            LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
            for (LanguageInfo language : languages.values()) {
                mimeTypes.addAll(language.getMimeTypes());
            }
            throw PolyglotEngineException.illegalState("No language for MIME type " + mimeType + " found. Supported languages are: " + mimeTypes);
        }
        return null;
    }

    private Map<String, PolyglotInstrument> initializeInstruments(Map<String, InstrumentInfo> infos) {
        LinkedHashMap<String, PolyglotInstrument> instruments = new LinkedHashMap<String, PolyglotInstrument>();
        List<InstrumentCache> cachedInstruments = InstrumentCache.load();
        for (InstrumentCache instrumentCache : cachedInstruments) {
            Instrument instrument;
            PolyglotInstrument instrumentImpl = new PolyglotInstrument(this, instrumentCache);
            instrumentImpl.info = EngineAccessor.LANGUAGE.createInstrument(instrumentImpl, instrumentCache.getId(), instrumentCache.getName(), instrumentCache.getVersion());
            instrumentImpl.api = instrument = this.impl.getAPIAccess().newInstrument((AbstractPolyglotImpl.AbstractInstrumentImpl)instrumentImpl);
            String id = instrumentImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, instrumentCache.getClassName());
            if (instruments.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, instrumentImpl.cache.getClassName(), ((PolyglotInstrument)instruments.get((Object)id)).cache.getClassName());
            }
            instruments.put(id, instrumentImpl);
            infos.put(id, instrumentImpl.info);
        }
        return instruments;
    }

    private Map<String, PolyglotLanguage> initializeLanguages(Map<String, LanguageInfo> infos) {
        LinkedHashMap<String, PolyglotLanguage> polyglotLanguages = new LinkedHashMap<String, PolyglotLanguage>();
        HashMap<String, LanguageCache> cachedLanguages = new HashMap<String, LanguageCache>();
        ArrayList<LanguageCache> sortedLanguages = new ArrayList<LanguageCache>();
        for (LanguageCache lang : LanguageCache.languages().values()) {
            String id = lang.getId();
            if (cachedLanguages.containsKey(id)) continue;
            sortedLanguages.add(lang);
            cachedLanguages.put(id, lang);
        }
        Collections.sort(sortedLanguages);
        LinkedHashSet<LanguageCache> serializedLanguages = new LinkedHashSet<LanguageCache>();
        HashSet<String> languageReferences = new HashSet<String>();
        HashMap<String, RuntimeException> initErrors = new HashMap<String, RuntimeException>();
        for (LanguageCache language : sortedLanguages) {
            languageReferences.addAll(language.getDependentLanguages());
        }
        for (LanguageCache language : sortedLanguages) {
            if (!language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        for (LanguageCache language : sortedLanguages) {
            if (language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        this.hostLanguage = this.createLanguage(LanguageCache.createHostLanguageCache(new String[0]), 0, null);
        int index = 1;
        for (LanguageCache cache : serializedLanguages) {
            PolyglotLanguage languageImpl = this.createLanguage(cache, index, (RuntimeException)initErrors.get(cache.getId()));
            String id = languageImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, cache.getClassName());
            if (polyglotLanguages.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, languageImpl.cache.getClassName(), ((PolyglotLanguage)polyglotLanguages.get((Object)id)).cache.getClassName());
            }
            polyglotLanguages.put(id, languageImpl);
            infos.put(id, languageImpl.info);
            ++index;
        }
        return polyglotLanguages;
    }

    private void visitLanguage(Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        this.visitLanguageImpl(new HashSet<String>(), initErrors, cachedLanguages, serializedLanguages, language);
    }

    private void visitLanguageImpl(Set<String> visitedIds, Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        Set<String> dependencies = language.getDependentLanguages();
        for (String dependency : dependencies) {
            LanguageCache dependentLanguage = cachedLanguages.get(dependency);
            if (dependentLanguage == null) continue;
            if (visitedIds.contains(dependency)) {
                initErrors.put(language.getId(), PolyglotEngineException.illegalState("Illegal cyclic language dependency found:" + language.getId() + " -> " + dependency));
                continue;
            }
            visitedIds.add(dependency);
            this.visitLanguageImpl(visitedIds, initErrors, cachedLanguages, serializedLanguages, dependentLanguage);
            visitedIds.remove(dependency);
        }
        serializedLanguages.add(language);
    }

    private PolyglotLanguage createLanguage(LanguageCache cache, int index, RuntimeException initError) {
        Language language;
        PolyglotLanguage languageImpl = new PolyglotLanguage(this, cache, index, index == 0, initError);
        languageImpl.api = language = this.impl.getAPIAccess().newLanguage((AbstractPolyglotImpl.AbstractLanguageImpl)languageImpl);
        return languageImpl;
    }

    private static void verifyId(String id, String className) {
        if (RESERVED_IDS.contains(id)) {
            throw new IllegalStateException(String.format("The language or instrument with class '%s' uses a reserved id '%s'. Resolve this by using a not reserved id for the language or instrument. The following ids are reserved %s for internal use.", className, id, RESERVED_IDS));
        }
        if (id.contains(".")) {
            throw new IllegalStateException(String.format("The language '%s' must not contain a period in its id '%s'. Remove all periods from the id to resolve this issue. ", className, id));
        }
    }

    private static RuntimeException failDuplicateId(String duplicateId, String className1, String className2) {
        return new IllegalStateException(String.format("Duplicate id '%s' specified by language or instrument with class '%s' and '%s'. Resolve this by specifying a unique id for each language or instrument.", duplicateId, className1, className2));
    }

    void checkState() {
        if (this.closed) {
            throw PolyglotEngineException.illegalState("Engine is already closed.");
        }
    }

    void addContext(PolyglotContextImpl context) {
        Context api;
        assert (Thread.holdsLock(this.lock));
        context.creatorApi = api = this.impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)context);
        context.currentApi = this.impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)context);
        if (this.limits != null) {
            this.limits.validate(context.config.limits);
        }
        this.workContextReferenceQueue();
        this.contexts.add((Object)context.weakReference);
        if (context.config.limits != null) {
            PolyglotLimits.EngineLimits l = this.limits;
            if (l == null) {
                this.limits = l = new PolyglotLimits.EngineLimits(this);
            }
            l.initialize(context.config.limits, context);
        }
        if (context.config.hostClassLoader != null) {
            context.engine.customHostClassLoader.invalidate();
        }
        if (!this.singleContext.isValid()) {
            PolyglotContextImpl.invalidateStaticContextAssumption();
        }
    }

    void removeContext(PolyglotContextImpl context) {
        assert (Thread.holdsLock(this.lock)) : "Must hold PolyglotEngineImpl.lock";
        this.contexts.remove((Object)context.weakReference);
        this.workContextReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeContext(PolyglotContextImpl context) {
        Object object = this.lock;
        synchronized (object) {
            assert (!context.weakReference.removed);
            context.weakReference.removed = true;
            context.weakReference.freeInstances.clear();
            this.removeContext(context);
        }
    }

    private void workContextReferenceQueue() {
        Reference<PolyglotContextImpl> ref;
        while ((ref = this.contextsReferenceQueue.poll()) != null) {
            PolyglotContextImpl.ContextWeakReference contextRef = (PolyglotContextImpl.ContextWeakReference)ref;
            if (contextRef.removed) continue;
            for (PolyglotLanguageInstance instance : contextRef.freeInstances) {
                instance.language.freeInstance(instance);
            }
            contextRef.freeInstances.clear();
            this.contexts.remove((Object)contextRef);
            contextRef.removed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportAllLanguageContexts(ContextsListener listener) {
        List<PolyglotContextImpl> allContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            if (this.contexts.isEmpty()) {
                return;
            }
            allContexts = this.collectAliveContexts();
        }
        for (PolyglotContextImpl context : allContexts) {
            listener.onContextCreated(context.creatorTruffleContext);
            for (PolyglotLanguageContext lc : context.contexts) {
                LanguageInfo language = lc.language.info;
                if (!lc.eventsEnabled || lc.env == null) continue;
                listener.onLanguageContextCreate(context.creatorTruffleContext, language);
                listener.onLanguageContextCreated(context.creatorTruffleContext, language);
                if (!lc.isInitialized()) continue;
                listener.onLanguageContextInitialize(context.creatorTruffleContext, language);
                listener.onLanguageContextInitialized(context.creatorTruffleContext, language);
                if (!lc.finalized) continue;
                listener.onLanguageContextFinalized(context.creatorTruffleContext, language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reportAllContextThreads(ThreadsListener listener) {
        Iterator<PolyglotContextImpl> iterator = this.lock;
        // MONITORENTER : iterator
        if (this.contexts.isEmpty()) {
            // MONITOREXIT : iterator
            return;
        }
        List<PolyglotContextImpl> allContexts = this.collectAliveContexts();
        // MONITOREXIT : iterator
        iterator = allContexts.iterator();
        block4: while (iterator.hasNext()) {
            Thread[] context;
            Thread[] threadArray = context = iterator.next();
            // MONITORENTER : context
            Thread[] threads = context.getSeenThreads().keySet().toArray(new Thread[0]);
            // MONITOREXIT : threadArray
            threadArray = threads;
            int n = threadArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block4;
                Thread thread = threadArray[n2];
                listener.onThreadInitialized(context.creatorTruffleContext, thread);
                ++n2;
            }
            break;
        }
        return;
    }

    public Language requirePublicLanguage(String id) {
        try {
            this.checkState();
            Language language = this.idToPublicLanguage.get(id);
            if (language == null) {
                String misspelledGuess = PolyglotEngineImpl.matchSpellingError(this.idToPublicLanguage.keySet(), id);
                String didYouMean = "";
                if (misspelledGuess != null) {
                    didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
                }
                throw PolyglotEngineException.illegalArgument(String.format("A language with id '%s' is not installed. %sInstalled languages are: %s.", id, didYouMean, this.getLanguages().keySet()));
            }
            return language;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    private static String matchSpellingError(Set<String> allIds, String enteredId) {
        String lowerCaseEnteredId = enteredId.toLowerCase();
        for (String id : allIds) {
            if (!id.toLowerCase().equals(lowerCaseEnteredId)) continue;
            return id;
        }
        return null;
    }

    public Instrument requirePublicInstrument(String id) {
        try {
            this.checkState();
            Instrument instrument = this.idToPublicInstrument.get(id);
            if (instrument == null) {
                String misspelledGuess = PolyglotEngineImpl.matchSpellingError(this.idToPublicInstrument.keySet(), id);
                String didYouMean = "";
                if (misspelledGuess != null) {
                    didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
                }
                throw PolyglotEngineException.illegalState(String.format("An instrument with id '%s' is not installed. %sInstalled instruments are: %s.", id, didYouMean, this.getInstruments().keySet()));
            }
            return instrument;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public void close(Engine sourceEngine, boolean cancelIfExecuting) {
        try {
            if (sourceEngine != this.creatorApi) {
                throw PolyglotEngineException.illegalState("Engine instances that were indirectly received using Context.get() cannot be closed.");
            }
            this.ensureClosed(cancelIfExecuting, false);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    <T extends TruffleLanguage<?>> PolyglotLanguage getLanguage(Class<T> languageClass, boolean fail) {
        PolyglotLanguage foundLanguage = this.classToLanguage.get(languageClass.getName());
        if (foundLanguage == null) {
            if (languageClass == HostLanguage.class) {
                return this.hostLanguage;
            }
            if (fail) {
                Set<String> languageNames = this.classToLanguage.keySet();
                throw PolyglotEngineException.illegalArgument("Cannot find language " + languageClass + " among " + languageNames);
            }
        }
        return foundLanguage;
    }

    <T extends TruffleLanguage<?>> PolyglotLanguageInstance getCurrentLanguageInstance(Class<T> languageClass) {
        PolyglotLanguage foundLanguage = this.getLanguage(languageClass, true);
        PolyglotLanguageContext context = foundLanguage.getCurrentLanguageContext();
        if (!context.isCreated()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PolyglotEngineException.illegalState(String.format("A context for language %s was not yet created.", languageClass.getName()));
        }
        return context.getLanguageInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureClosed(boolean cancelIfExecuting, boolean inShutdownHook) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                block51: {
                    PolyglotInstrument instrumentImpl;
                    Iterator<PolyglotImpl.VMObject> iterator;
                    block50: {
                        this.workContextReferenceQueue();
                        List<PolyglotContextImpl> localContexts = this.collectAliveContexts();
                        if (!inShutdownHook) {
                            if (!cancelIfExecuting) {
                                for (PolyglotContextImpl context : localContexts) {
                                    assert (!Thread.holdsLock(context));
                                    PolyglotContextImpl polyglotContextImpl = context;
                                    synchronized (polyglotContextImpl) {
                                        if (context.hasActiveOtherThread(false) && context.closingThread == null) {
                                            throw PolyglotEngineException.illegalState(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                                        }
                                    }
                                }
                            }
                            for (PolyglotContextImpl context : localContexts) {
                                assert (!Thread.holdsLock(context));
                                boolean closeCompleted = context.closeImpl(cancelIfExecuting, cancelIfExecuting, true);
                                if (!closeCompleted && !cancelIfExecuting) {
                                    throw PolyglotEngineException.illegalState(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                                }
                                context.checkSubProcessFinished();
                            }
                            if (cancelIfExecuting) {
                                this.getCancelHandler().cancel(localContexts);
                            }
                        }
                        if (!inShutdownHook) {
                            if (!this.boundEngine) {
                                for (PolyglotContextImpl context : localContexts) {
                                    PolyglotContextImpl.disposeStaticContext(context);
                                }
                            }
                            this.contexts.clear();
                            if (EngineAccessor.RUNTIME.onEngineClosing(this.runtimeData)) {
                                return;
                            }
                        }
                        iterator = this.idToInstrument.values().iterator();
                        while (true) {
                            instrumentImpl = (PolyglotInstrument)iterator.next();
                            instrumentImpl.notifyClosing();
                            continue;
                            break;
                        }
                        finally {
                            if (!iterator.hasNext()) break block50;
                        }
                    }
                    iterator = this.idToInstrument.values().iterator();
                    while (true) {
                        instrumentImpl = (PolyglotInstrument)iterator.next();
                        instrumentImpl.ensureClosed();
                        continue;
                        break;
                    }
                    finally {
                        if (!iterator.hasNext()) break block51;
                    }
                }
                if (this.specializationStatistics != null) {
                    StringWriter logMessage = new StringWriter();
                    try (PrintWriter writer = new PrintWriter(logMessage);){
                        if (!this.specializationStatistics.hasData()) {
                            writer.printf("No specialization statistics data was collected. Either no node with @%s annotations was executed or the interpreter was not compiled with -J-Dtruffle.dsl.GenerateSpecializationStatistics=true e.g as parameter to the javac tool.", Specialization.class.getSimpleName());
                        } else {
                            this.specializationStatistics.printHistogram(writer);
                        }
                    }
                    this.getEngineLogger().log(Level.INFO, String.format("Specialization histogram: %n%s", logMessage.toString()));
                }
                if (!inShutdownHook) {
                    EngineAccessor.RUNTIME.onEngineClosed(this.runtimeData);
                    Object loggers = this.getEngineLoggers();
                    if (loggers != null) {
                        EngineAccessor.LANGUAGE.closeEngineLoggers(loggers);
                    }
                    if (this.logHandler != null) {
                        this.logHandler.close();
                    }
                    this.closed = true;
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        language.close();
                    }
                    if (this.runtimeData != null) {
                        EngineAccessor.RUNTIME.flushCompileQueue(this.runtimeData);
                    }
                    ENGINES.remove(this);
                } else if (this.logHandler != null) {
                    this.logHandler.flush();
                }
            }
        }
    }

    List<PolyglotContextImpl> collectAliveContexts() {
        assert (Thread.holdsLock(this.lock));
        ArrayList<PolyglotContextImpl> localContexts = new ArrayList<PolyglotContextImpl>(this.contexts.size());
        for (PolyglotContextImpl.ContextWeakReference ref : this.contexts) {
            PolyglotContextImpl context = (PolyglotContextImpl)ref.get();
            if (context != null) {
                localContexts.add(context);
                continue;
            }
            this.contexts.remove((Object)ref);
        }
        return localContexts;
    }

    public Map<String, Instrument> getInstruments() {
        try {
            this.checkState();
            return this.idToPublicInstrument;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public Map<String, Language> getLanguages() {
        try {
            this.checkState();
            return this.idToPublicLanguage;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public OptionDescriptors getOptions() {
        try {
            this.checkState();
            return this.engineOptionValues.getDescriptors();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Source> getCachedSources() {
        List<PolyglotContextImpl> activeContexts;
        this.checkState();
        HashSet<Source> sources = new HashSet<Source>();
        Object object = this.lock;
        synchronized (object) {
            activeContexts = this.collectAliveContexts();
        }
        for (PolyglotContextImpl context : activeContexts) {
            for (PolyglotLanguageContext language : context.contexts) {
                PolyglotLanguageInstance instance = language.getLanguageInstanceOrNull();
                if (instance == null) continue;
                instance.listCachedSources(sources);
            }
        }
        object = this.lock;
        synchronized (object) {
            for (PolyglotLanguage language : this.idToLanguage.values()) {
                for (PolyglotLanguageInstance instance : language.getInstancePool()) {
                    instance.listCachedSources(sources);
                }
            }
        }
        return sources;
    }

    Collection<CallTarget> getCallTargets() {
        return EngineAccessor.INSTRUMENT.getLoadedCallTargets(this.instrumentationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionDescriptors getAllOptions() {
        this.checkState();
        if (this.allOptions == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.allOptions == null) {
                    ArrayList<OptionDescriptors> allDescriptors = new ArrayList<OptionDescriptors>();
                    allDescriptors.add(this.engineOptionValues.getDescriptors());
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        allDescriptors.add(language.getOptionsInternal());
                    }
                    for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                        allDescriptors.add(instrument.getAllOptionsInternal());
                    }
                    this.allOptions = OptionDescriptors.createUnion((OptionDescriptors[])allDescriptors.toArray(new OptionDescriptors[0]));
                }
            }
        }
        return this.allOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInitialize() {
        Object object = this.lock;
        synchronized (object) {
            this.preInitializedContext.set(PolyglotContextImpl.preInitialize(this));
        }
    }

    void intitializeStore(boolean previousStore, boolean newStore) {
        if (newStore) {
            if (previousStore && this.boundEngine && this.singleContext.isValid()) {
                this.singleContext.invalidate();
            } else {
                this.initializeMultiContext(null);
            }
            PolyglotContextImpl.singleContextState.getContextThreadLocal().enableStore();
        }
    }

    void finalizeStore() {
        assert (Thread.holdsLock(this.lock));
        this.out = null;
        this.err = null;
        this.in = null;
        this.logHandler = null;
        EngineAccessor.INSTRUMENT.finalizeStoreInstrumentationHandler(this.instrumentationHandler);
        if (this.storeEngine && this.boundEngine && !this.singleContext.isValid()) {
            this.singleContext = Truffle.getRuntime().createAssumption("Single context after preinitialization.");
        }
    }

    static void resetPreInitializedEngine() {
        ENGINES.clear();
    }

    void initializeHostAccess(HostAccess policy) {
        assert (Thread.holdsLock(this.lock));
        assert (policy != null);
        HostClassCache cache = HostClassCache.findOrInitialize(this.getAPIAccess(), policy, this.contextClassLoader);
        if (this.hostClassCache != null) {
            if (!this.hostClassCache.hostAccess.equals((Object)cache.hostAccess)) {
                throw PolyglotEngineException.illegalState("Found different host access configuration for a context with a shared engine. The host access configuration must be the same for all contexts of an engine. Provide the same host access configuration using the Context.Builder.allowHostAccess method when constructing the context.");
            }
        } else {
            this.hostClassCache = cache;
        }
    }

    HostClassCache getHostClassCache() {
        return this.hostClassCache;
    }

    @CompilerDirectives.TruffleBoundary
    int getAsynchronousStackDepth() {
        return this.asynchronousStackDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    void setAsynchronousStackDepth(PolyglotInstrument polyglotInstrument, int depth) {
        assert (depth >= 0) : String.format("Wrong depth: %d", depth);
        int newDepth = 0;
        Object object = this.lock;
        synchronized (object) {
            polyglotInstrument.requestedAsyncStackDepth = depth;
            for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                if (instrument.requestedAsyncStackDepth <= newDepth) continue;
                newDepth = instrument.requestedAsyncStackDepth;
            }
        }
        this.asynchronousStackDepth = newDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CancelHandler getCancelHandler() {
        if (this.cancelHandler == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.cancelHandler == null) {
                    this.cancelHandler = new CancelHandler();
                }
            }
        }
        return this.cancelHandler;
    }

    public String getImplementationName() {
        try {
            return Truffle.getRuntime().getName();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createContext(OutputStream configOut, OutputStream configErr, InputStream configIn, boolean allowHostLookup, HostAccess hostAccess, PolyglotAccess polyglotAccess, boolean allowNativeAccess, boolean allowCreateThread, boolean allowHostIO, boolean allowHostClassLoading, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> arguments, String[] onlyLanguages, FileSystem fileSystem, Object logHandlerOrStream, boolean allowCreateProcess, ProcessHandler processHandler, EnvironmentAccess environmentAccess, Map<String, String> environment, ZoneId zone, Object limitsImpl, String currentWorkingDirectory, ClassLoader hostClassLoader) {
        boolean hasContextBindings;
        boolean contextAddedToEngine;
        boolean replayEvents;
        PolyglotContextImpl context;
        Object fs;
        Object error;
        block50: {
            try {
                ProcessHandler useProcessHandler;
                InputStream useIn;
                FileSystem internalFs;
                Object object = this.lock;
                synchronized (object) {
                    this.checkState();
                    if (this.boundEngine && !this.contexts.isEmpty()) {
                        throw PolyglotEngineException.illegalArgument("Automatically created engines cannot be used to create more than one context. Use Engine.newBuilder().build() to construct a new engine and pass it using Context.newBuilder().engine(engine).build().");
                    }
                    this.initializeHostAccess(hostAccess);
                }
                EconomicSet allowedLanguages = EconomicSet.create();
                if (onlyLanguages.length == 0) {
                    allowedLanguages.addAll(this.getLanguages().keySet());
                } else {
                    allowedLanguages.addAll(Arrays.asList(onlyLanguages));
                }
                error = this.getAPIAccess().validatePolyglotAccess(polyglotAccess, (UnmodifiableEconomicSet)allowedLanguages);
                if (error != null) {
                    throw PolyglotEngineException.illegalArgument((String)error);
                }
                if (!ALLOW_IO) {
                    if (fileSystem == null) {
                        fileSystem = FileSystems.newNoIOFileSystem();
                    }
                    fs = fileSystem;
                    internalFs = fileSystem;
                } else if (allowHostIO) {
                    internalFs = fs = fileSystem != null ? fileSystem : FileSystems.newDefaultFileSystem();
                } else {
                    fs = FileSystems.newNoIOFileSystem();
                    internalFs = FileSystems.newLanguageHomeFileSystem();
                }
                if (currentWorkingDirectory != null) {
                    fs.setCurrentWorkingDirectory(fs.parsePath(currentWorkingDirectory));
                    internalFs.setCurrentWorkingDirectory(internalFs.parsePath(currentWorkingDirectory));
                }
                OutputStream useOut = configOut == null || configOut == EngineAccessor.INSTRUMENT.getOut(this.out) ? this.out : EngineAccessor.INSTRUMENT.createDelegatingOutput(configOut, this.out);
                OutputStream useErr = configErr == null || configErr == EngineAccessor.INSTRUMENT.getOut(this.err) ? this.err : EngineAccessor.INSTRUMENT.createDelegatingOutput(configErr, this.err);
                Handler useHandler = PolyglotLoggers.asHandler(logHandlerOrStream);
                Handler handler = useHandler = useHandler != null ? useHandler : this.logHandler;
                useHandler = useHandler != null ? useHandler : PolyglotLoggers.createDefaultHandler(configErr == null ? EngineAccessor.INSTRUMENT.getOut(this.err) : configErr);
                InputStream inputStream = useIn = configIn == null ? this.in : configIn;
                if (allowCreateProcess) {
                    if (!ALLOW_CREATE_PROCESS) {
                        throw PolyglotEngineException.illegalArgument("Cannot allowCreateProcess() because the privilege is removed at image build time");
                    }
                    useProcessHandler = processHandler != null ? processHandler : ProcessHandlers.newDefaultProcessHandler();
                } else {
                    useProcessHandler = null;
                }
                if (!ALLOW_ENVIRONMENT_ACCESS && environmentAccess != EnvironmentAccess.NONE) {
                    throw PolyglotEngineException.illegalArgument("Cannot allow EnvironmentAccess because the privilege is removed at image build time");
                }
                PolyglotLimits polyglotLimits = (PolyglotLimits)limitsImpl;
                PolyglotContextConfig config = new PolyglotContextConfig(this, useOut, useErr, useIn, allowHostLookup, polyglotAccess, allowNativeAccess, allowCreateThread, allowHostClassLoading, allowExperimentalOptions, classFilter, arguments, (EconomicSet<String>)allowedLanguages, options, (FileSystem)fs, internalFs, useHandler, allowCreateProcess, useProcessHandler, environmentAccess, environment, zone, polyglotLimits, hostClassLoader);
                context = this.loadPreinitializedContext(config, hostAccess);
                replayEvents = false;
                contextAddedToEngine = false;
                if (context == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.checkState();
                        context = new PolyglotContextImpl(this, config);
                        this.addContext(context);
                        contextAddedToEngine = true;
                        break block50;
                    }
                }
                if (context.engine == this) {
                    replayEvents = true;
                }
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
        }
        try {
            if (replayEvents) {
                context.resizeContextLocals(this.contextLocalLocations);
            } else {
                try {
                    error = context;
                    synchronized (error) {
                        context.initializeContextLocals();
                    }
                }
                catch (Throwable t) {
                    if (contextAddedToEngine) {
                        fs = this.lock;
                        synchronized (fs) {
                            this.disposeContext(context);
                            if (this.boundEngine) {
                                this.ensureClosed(false, false);
                            }
                        }
                    }
                    throw t;
                }
            }
            hasContextBindings = EngineAccessor.INSTRUMENT.hasContextBindings(this);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
        }
        if (replayEvents && hasContextBindings) {
            PolyglotContextImpl prev;
            try {
                prev = this.enter(context, this.getUncachedLocation(), true);
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
            }
            try {
                context.replayInstrumentationEvents();
            }
            catch (Throwable t) {
                throw PolyglotImpl.guestToHostException(context.getHostContext(), t, true);
            }
            finally {
                try {
                    this.leave(prev, context);
                }
                catch (Throwable t) {
                    throw PolyglotImpl.guestToHostException(context.getHostContext(), t, false);
                }
            }
        }
        return context.creatorApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotContextImpl loadPreinitializedContext(PolyglotContextConfig config, HostAccess hostAccess) {
        PolyglotContextImpl context = this.preInitializedContext.getAndSet(null);
        if (context != null) {
            FileSystems.PreInitializeContextFileSystem preInitFs = (FileSystems.PreInitializeContextFileSystem)context.config.fileSystem;
            preInitFs.onLoadPreinitializedContext(config.fileSystem);
            FileSystem oldFileSystem = config.fileSystem;
            config.fileSystem = preInitFs;
            preInitFs = (FileSystems.PreInitializeContextFileSystem)context.config.internalFileSystem;
            preInitFs.onLoadPreinitializedContext(config.internalFileSystem);
            FileSystem oldInternalFileSystem = config.internalFileSystem;
            config.internalFileSystem = preInitFs;
            boolean patchResult = false;
            Object object = this.lock;
            synchronized (object) {
                this.addContext(context);
            }
            try {
                patchResult = context.patch(config);
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.removeContext(context);
                }
                if (patchResult) {
                    HashSet<PolyglotInstrument> toCreate = null;
                    for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                        if (instrument.getOptionValuesIfExists() == null) continue;
                        if (toCreate == null) {
                            toCreate = new HashSet<PolyglotInstrument>();
                        }
                        toCreate.add(instrument);
                    }
                    if (toCreate != null) {
                        PolyglotEngineImpl.ensureInstrumentsCreated(toCreate);
                    }
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.addContext(context);
                    }
                }
                context.closeImpl(false, false, false);
                PolyglotContextImpl.disposeStaticContext(null);
                config.fileSystem = oldFileSystem;
                config.internalFileSystem = oldInternalFileSystem;
                PolyglotEngineImpl engine = new PolyglotEngineImpl(this);
                this.ensureClosed(true, false);
                Object object4 = engine.lock;
                synchronized (object4) {
                    engine.creatorApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)engine);
                    engine.currentApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)engine);
                    engine.initializeHostAccess(hostAccess);
                    context = new PolyglotContextImpl(engine, config);
                    engine.addContext(context);
                }
                throw throwable;
            }
            synchronized (object) {
                this.removeContext(context);
            }
            if (patchResult) {
                HashSet<PolyglotInstrument> toCreate = null;
                for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                    if (instrument.getOptionValuesIfExists() == null) continue;
                    if (toCreate == null) {
                        toCreate = new HashSet<PolyglotInstrument>();
                    }
                    toCreate.add(instrument);
                }
                if (toCreate != null) {
                    PolyglotEngineImpl.ensureInstrumentsCreated(toCreate);
                }
                Object object5 = this.lock;
                synchronized (object5) {
                    this.addContext(context);
                }
            } else {
                context.closeImpl(false, false, false);
                PolyglotContextImpl.disposeStaticContext(null);
                config.fileSystem = oldFileSystem;
                config.internalFileSystem = oldInternalFileSystem;
                PolyglotEngineImpl engine = new PolyglotEngineImpl(this);
                this.ensureClosed(true, false);
                Object object6 = engine.lock;
                synchronized (object6) {
                    engine.creatorApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)engine);
                    engine.currentApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)engine);
                    engine.initializeHostAccess(hostAccess);
                    context = new PolyglotContextImpl(engine, config);
                    engine.addContext(context);
                }
            }
        }
        return context;
    }

    OptionValuesImpl getEngineOptionValues() {
        return this.engineOptionValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getOrCreateEngineLoggers() {
        Object res = this.engineLoggers;
        if (res == null) {
            Object object = this.lock;
            synchronized (object) {
                res = this.engineLoggers;
                if (res == null) {
                    res = EngineAccessor.LANGUAGE.createEngineLoggers(PolyglotLoggers.LoggerCache.newEngineLoggerCache(this), this.logLevels);
                    for (PolyglotContextImpl.ContextWeakReference contextRef : this.contexts) {
                        PolyglotContextImpl context = (PolyglotContextImpl)contextRef.get();
                        if (context == null || context.config.logLevels.isEmpty()) continue;
                        EngineAccessor.LANGUAGE.configureLoggers(context, context.config.logLevels, res);
                    }
                    this.engineLoggers = res;
                }
            }
        }
        return res;
    }

    Object getEngineLoggers() {
        return this.engineLoggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> getFileTypeDetectorsSupplier() {
        Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> res = this.fileTypeDetectorsSupplier;
        if (res == null) {
            Object object = this.lock;
            synchronized (object) {
                res = this.fileTypeDetectorsSupplier;
                if (res == null) {
                    ArrayList<LanguageCache> languageCaches = new ArrayList<LanguageCache>(this.idToLanguage.size());
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        languageCaches.add(language.cache);
                    }
                    this.fileTypeDetectorsSupplier = res = FileSystems.newFileTypeDetectorsSupplier(languageCaches);
                }
            }
        }
        return res;
    }

    boolean needsEnter(PolyglotContextImpl context) {
        if (PolyglotContextImpl.getSingleContextState().getSingleContextAssumption().isValid()) {
            return !PolyglotContextImpl.singleContextState.getContextThreadLocal().isSet();
        }
        return PolyglotContextImpl.currentNotEntered() != context;
    }

    Object enterIfNeeded(PolyglotContextImpl context, boolean pollSafepoint) {
        if (this.needsEnter(context)) {
            return this.enter(context, this.getUncachedLocation(), pollSafepoint);
        }
        assert (PolyglotContextImpl.currentNotEntered() != null);
        return NO_ENTER;
    }

    void leaveIfNeeded(Object prev, PolyglotContextImpl context) {
        if (prev != NO_ENTER) {
            this.leave((PolyglotContextImpl)prev, context);
        }
    }

    PolyglotContextImpl enter(PolyglotContextImpl context, Node safepointLocation, boolean pollSafepoint) {
        PolyglotContextImpl prev;
        PolyglotThreadInfo info = context.cachedThreadInfo;
        boolean enterReverted = false;
        if (CompilerDirectives.injectBranchProbability(0.75, info.getThread() == Thread.currentThread())) {
            prev = info.enterInternal();
            if (CompilerDirectives.injectBranchProbability(0.9999, info == context.cachedThreadInfo)) {
                try {
                    info.notifyEnter(this, context);
                }
                catch (Throwable e) {
                    info.leaveInternal(prev);
                    throw e;
                }
                return prev;
            }
            info.leaveInternal(prev);
            enterReverted = true;
        }
        prev = context.enterThreadChanged(safepointLocation, enterReverted, pollSafepoint);
        assert (PolyglotEngineImpl.verifyContext(context));
        return prev;
    }

    private static boolean verifyContext(PolyglotContextImpl context) {
        return context == PolyglotContextImpl.currentNotEntered() || context.closed || context.invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leave(PolyglotContextImpl prev, PolyglotContextImpl context) {
        assert (context.closed || context.closingThread == Thread.currentThread() || PolyglotContextImpl.currentNotEntered() == context) : "Cannot leave context that is currently not entered. Forgot to enter or leave a context?";
        boolean entered = true;
        PolyglotThreadInfo info = context.cachedThreadInfo;
        if (CompilerDirectives.injectBranchProbability(0.75, info.getThread() == Thread.currentThread())) {
            try {
                info.notifyLeave(this, context);
            }
            finally {
                info.leaveInternal(prev);
                entered = false;
            }
            if (CompilerDirectives.injectBranchProbability(0.9999, info == context.cachedThreadInfo)) {
                return;
            }
        }
        context.leaveThreadChanged(prev, entered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLocals.LocalLocation[] addContextLocals(List<? extends PolyglotLocals.AbstractContextLocal<?>> newLocals) {
        PolyglotLocals.LocalLocation[] newLocations;
        StableLocalLocations newStableLocations;
        List<PolyglotContextImpl> aliveContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            StableLocalLocations stableLocations = this.contextLocalLocations;
            int index = stableLocations.locations.length;
            PolyglotLocals.LocalLocation[] locationsCopy = Arrays.copyOf(stableLocations.locations, stableLocations.locations.length + newLocals.size());
            for (PolyglotLocals.AbstractContextLocal<?> newLocal : newLocals) {
                locationsCopy[index] = newLocal.createLocation(index);
                newLocal.initializeLocation(locationsCopy[index]);
                ++index;
            }
            aliveContexts = this.collectAliveContexts();
            this.contextLocalLocations = newStableLocations = new StableLocalLocations(locationsCopy);
            stableLocations.assumption.invalidate("Context local added");
            newLocations = Arrays.copyOfRange(locationsCopy, stableLocations.locations.length, index);
        }
        iterator = aliveContexts.iterator();
        while (iterator.hasNext()) {
            PolyglotContextImpl context;
            PolyglotContextImpl polyglotContextImpl = context = iterator.next();
            synchronized (polyglotContextImpl) {
                if (context.localsCleared) {
                    continue;
                }
                context.resizeContextLocals(newStableLocations);
            }
        }
        return newLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLocals.LocalLocation[] addContextThreadLocals(List<? extends PolyglotLocals.AbstractContextThreadLocal<?>> newLocals) {
        PolyglotLocals.LocalLocation[] newLocations;
        StableLocalLocations newStableLocations;
        List<PolyglotContextImpl> aliveContexts;
        Iterator<PolyglotContextImpl> iterator = this.lock;
        synchronized (iterator) {
            StableLocalLocations stableLocations = this.contextThreadLocalLocations;
            int index = stableLocations.locations.length;
            PolyglotLocals.LocalLocation[] locationsCopy = Arrays.copyOf(stableLocations.locations, stableLocations.locations.length + newLocals.size());
            for (PolyglotLocals.AbstractContextThreadLocal<?> newLocal : newLocals) {
                locationsCopy[index] = newLocal.createLocation(index);
                newLocal.initializeLocation(locationsCopy[index]);
                ++index;
            }
            aliveContexts = this.collectAliveContexts();
            this.contextThreadLocalLocations = newStableLocations = new StableLocalLocations(locationsCopy);
            stableLocations.assumption.invalidate("Context thread local added");
            newLocations = Arrays.copyOfRange(locationsCopy, stableLocations.locations.length, index);
        }
        iterator = aliveContexts.iterator();
        while (iterator.hasNext()) {
            PolyglotContextImpl context;
            PolyglotContextImpl polyglotContextImpl = context = iterator.next();
            synchronized (polyglotContextImpl) {
                if (context.localsCleared) {
                    continue;
                }
                context.resizeContextThreadLocals(newStableLocations);
            }
        }
        return newLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PolyglotEngineImpl getFallbackEngine() {
        if (fallbackEngine != null) return fallbackEngine;
        Class<PolyglotImpl> clazz = PolyglotImpl.class;
        synchronized (PolyglotImpl.class) {
            if (fallbackEngine != null) return fallbackEngine;
            fallbackEngine = PolyglotImpl.getInstance().createDefaultEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fallbackEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetFallbackEngine() {
        Class<PolyglotImpl> clazz = PolyglotImpl.class;
        synchronized (PolyglotImpl.class) {
            fallbackEngine = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        boolean createProcess = true;
        boolean environmentAccess = true;
        boolean io = true;
        String[] stringArray = DISABLED_PRIVILEGES;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String privilege;
            switch (privilege = stringArray[i]) {
                case "createProcess": {
                    createProcess = false;
                    continue block10;
                }
                case "environmentAccess": {
                    environmentAccess = false;
                    continue block10;
                }
                case "io": {
                    io = false;
                    continue block10;
                }
                default: {
                    throw new Error("Invalid privilege name for DisablePrivileges: " + privilege);
                }
            }
        }
        ALLOW_CREATE_PROCESS = createProcess;
        ALLOW_ENVIRONMENT_ACCESS = environmentAccess;
        ALLOW_IO = io;
        NO_ENTER = new Object();
    }

    private static final class NoLocationNode
    extends HostToGuestRootNode {
        NoLocationNode(PolyglotEngineImpl engine) {
            super(engine);
        }

        @Override
        protected Class<?> getReceiverType() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        protected Object executeImpl(PolyglotLanguageContext languageContext, Object receiver, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public boolean isInternal() {
            return true;
        }
    }

    static final class StableLocalLocations {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final PolyglotLocals.LocalLocation[] locations;
        final Assumption assumption = Truffle.getRuntime().createAssumption();

        StableLocalLocations(PolyglotLocals.LocalLocation[] locations) {
            this.locations = locations;
        }
    }

    static final class LogConfig {
        final Map<String, Level> logLevels = new HashMap<String, Level>();
        String logFile;

        LogConfig() {
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class InterruptExecution
    extends AbstractTruffleException {
        private static final long serialVersionUID = 8652484189010224048L;

        InterruptExecution(Node location) {
            super("Execution got interrupted.", location);
        }

        @ExportMessage
        ExceptionType getExceptionType() {
            return ExceptionType.INTERRUPT;
        }
    }

    static final class CancelExecution
    extends ThreadDeath {
        private final Node location;
        private final String cancelMessage;
        private final boolean resourceLimit;

        CancelExecution(Node location, String cancelMessage, boolean resourceLimit) {
            this.location = location;
            this.cancelMessage = cancelMessage;
            this.resourceLimit = resourceLimit;
        }

        Node getLocation() {
            return this.location;
        }

        SourceSection getSourceLocation() {
            return this.location == null ? null : this.location.getEncapsulatingSourceSection();
        }

        public boolean isResourceLimit() {
            return this.resourceLimit;
        }

        @Override
        public String getMessage() {
            if (this.cancelMessage == null) {
                return "Execution got cancelled.";
            }
            return this.cancelMessage;
        }
    }

    final class CancelHandler {
        private final Instrumenter instrumenter;
        private volatile EventBinding<?> cancellationBinding;
        private int cancellationUsers;

        CancelHandler() {
            this.instrumenter = (Instrumenter)EngineAccessor.INSTRUMENT.getEngineInstrumenter(PolyglotEngineImpl.this.instrumentationHandler);
        }

        void cancel(List<PolyglotContextImpl> localContexts) {
            this.cancel(localContexts, 0L, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel(List<PolyglotContextImpl> localContexts, long startMillis, Duration timeout) {
            block9: {
                boolean cancelling = false;
                for (PolyglotContextImpl context : localContexts) {
                    if (!context.cancelling && !context.interrupting) continue;
                    cancelling = true;
                    break;
                }
                if (cancelling) {
                    this.enableCancel();
                    try {
                        for (PolyglotContextImpl context : localContexts) {
                            context.sendInterrupt();
                        }
                        if (timeout == null) {
                            for (PolyglotContextImpl context : localContexts) {
                                context.waitForClose();
                            }
                            break block9;
                        }
                        long cancelTimeoutMillis = timeout != Duration.ZERO ? timeout.toMillis() : 0L;
                        boolean success = true;
                        for (PolyglotContextImpl context : localContexts) {
                            if (context.waitForThreads(startMillis, cancelTimeoutMillis)) continue;
                            success = false;
                        }
                        boolean bl = success;
                        return bl;
                    }
                    finally {
                        this.disableCancel();
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enableCancel() {
            Object object = PolyglotEngineImpl.this.lock;
            synchronized (object) {
                if (this.cancellationBinding == null) {
                    this.cancellationBinding = this.instrumenter.attachExecutionEventListener(SourceSectionFilter.ANY, new ExecutionEventListener(){

                        @Override
                        public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
                            this.cancelExecution(context);
                        }

                        @Override
                        public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
                            if (!(exception instanceof CancelExecution)) {
                                this.cancelExecution(context);
                            }
                        }

                        @Override
                        public void onEnter(EventContext context, VirtualFrame frame) {
                            this.cancelExecution(context);
                        }

                        @CompilerDirectives.TruffleBoundary
                        private void cancelExecution(EventContext eventContext) {
                            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
                            if (context.invalid || context.cancelling) {
                                throw context.createCancelException(eventContext.getInstrumentedNode());
                            }
                            if (context.interrupting) {
                                throw new InterruptExecution(eventContext.getInstrumentedNode());
                            }
                        }
                    });
                }
                ++this.cancellationUsers;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disableCancel() {
            Object object = PolyglotEngineImpl.this.lock;
            synchronized (object) {
                int usersLeft = --this.cancellationUsers;
                if (usersLeft <= 0) {
                    EventBinding<?> b = this.cancellationBinding;
                    if (b != null) {
                        b.dispose();
                    }
                    this.cancellationBinding = null;
                }
            }
        }
    }

    private static final class PolyglotShutDownHook
    implements Runnable {
        private PolyglotShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PolyglotEngineImpl[] engines;
            PolyglotEngineImpl[] polyglotEngineImplArray = ENGINES;
            synchronized (polyglotEngineImplArray) {
                engines = ENGINES.keySet().toArray(new PolyglotEngineImpl[0]);
            }
            for (PolyglotEngineImpl engine : engines) {
                if (DEBUG_MISSING_CLOSE) {
                    PrintStream out = System.out;
                    out.println("Missing close on vm shutdown: ");
                    out.print(" InitializedLanguages:");
                    Object object = engine.lock;
                    synchronized (object) {
                        for (PolyglotContextImpl context : engine.collectAliveContexts()) {
                            for (PolyglotLanguageContext langContext : context.contexts) {
                                if (langContext.env == null) continue;
                                out.print(langContext.language.getId());
                                out.print(", ");
                            }
                        }
                    }
                    out.println();
                    engine.createdLocation.printStackTrace();
                }
                if (engine == null) continue;
                engine.ensureClosed(false, true);
            }
        }
    }
}

