/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotIterable;
import com.oracle.truffle.polyglot.PolyglotIterator;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.PolyglotMapEntry;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

@GenerateUncached
abstract class ToHostNode
extends Node {
    static final int LIMIT = 5;
    static final int HIGHEST = 0;
    static final int STRICT = 1;
    static final int LOOSE = 2;
    static final int COERCE = 3;
    static final int FUNCTION_PROXY = 4;
    static final int OBJECT_PROXY_IFACE = 5;
    static final int OBJECT_PROXY_CLASS = 6;
    static final int HOST_PROXY = 7;
    static final int LOWEST = 8;
    static final int[] PRIORITIES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    ToHostNode() {
    }

    public abstract Object execute(Object var1, Class<?> var2, Type var3, PolyglotLanguageContext var4, boolean var5);

    @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
    protected Object doCached(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext, boolean useCustomTargetTypes, @CachedLibrary(value="operand") InteropLibrary interop, @Cached(value="targetType") Class<?> cachedTargetType, @Cached(value="isPrimitiveTarget(cachedTargetType)") boolean primitiveTarget, @Cached(value="allowsImplementation(languageContext, targetType)") boolean allowsImplementation, @Cached TargetMappingNode targetMapping, @Cached BranchProfile error) {
        return ToHostNode.convertImpl(operand, cachedTargetType, genericType, allowsImplementation, primitiveTarget, languageContext, interop, useCustomTargetTypes, targetMapping, error);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean allowsImplementation(PolyglotLanguageContext languagecontext, Class<?> type) {
        if (languagecontext == null) {
            return false;
        }
        if (!HostInteropReflect.isAbstractType(type)) {
            return false;
        }
        HostClassDesc classDesc = languagecontext.getEngine().getHostClassCache().forClass(type);
        return classDesc.isAllowsImplementation() && classDesc.isAllowedTargetType();
    }

    @Specialization(replaces={"doCached"})
    @CompilerDirectives.TruffleBoundary
    protected static Object doGeneric(Object operand, Class<?> targetType, Type genericType, PolyglotLanguageContext languageContext, boolean useTargetMapping) {
        return ToHostNode.convertImpl(operand, targetType, genericType, ToHostNode.allowsImplementation(languageContext, targetType), ToHostNode.isPrimitiveTarget(targetType), languageContext, InteropLibrary.getUncached(operand), useTargetMapping, TargetMappingNode.getUncached(), BranchProfile.getUncached());
    }

    static Object convertLossLess(Object value, Class<?> requestedType, InteropLibrary interop) {
        try {
            if (interop.isNumber(value)) {
                if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                    return interop.asByte(value);
                }
                if (requestedType == Short.TYPE || requestedType == Short.class) {
                    return interop.asShort(value);
                }
                if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                    return interop.asInt(value);
                }
                if (requestedType == Long.TYPE || requestedType == Long.class) {
                    return interop.asLong(value);
                }
                if (requestedType == Float.TYPE || requestedType == Float.class) {
                    return Float.valueOf(interop.asFloat(value));
                }
                if (requestedType == Double.TYPE || requestedType == Double.class) {
                    return interop.asDouble(value);
                }
                if (requestedType == Number.class) {
                    return ToHostNode.convertToNumber(value, interop);
                }
            } else if (interop.isBoolean(value)) {
                if (requestedType == Boolean.TYPE || requestedType == Boolean.class) {
                    return interop.asBoolean(value);
                }
            } else if (interop.isString(value)) {
                if (requestedType == Character.TYPE || requestedType == Character.class) {
                    String str = interop.asString(value);
                    if (str.length() == 1) {
                        return Character.valueOf(str.charAt(0));
                    }
                } else if (requestedType == String.class || requestedType == CharSequence.class) {
                    return interop.asString(value);
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object value) {
        return value.toString();
    }

    private static Object convertImpl(Object value, Class<?> targetType, Type genericType, boolean allowsImplementation, boolean primitiveTargetType, PolyglotLanguageContext languageContext, InteropLibrary interop, boolean useCustomTargetTypes, TargetMappingNode targetMapping, BranchProfile error) {
        Object convertedValue;
        Object result;
        if (useCustomTargetTypes && (result = targetMapping.execute(value, targetType, languageContext, interop, false, 0, 1)) != TargetMappingNode.NO_RESULT) {
            return result;
        }
        if (primitiveTargetType && (convertedValue = ToHostNode.convertLossLess(value, targetType, interop)) != null) {
            return convertedValue;
        }
        if (HostObject.isJavaInstance(targetType, value)) {
            return HostObject.valueOf(value);
        }
        if (useCustomTargetTypes && (convertedValue = targetMapping.execute(value, targetType, languageContext, interop, false, 2, 2)) != TargetMappingNode.NO_RESULT) {
            return convertedValue;
        }
        if (primitiveTargetType && (convertedValue = ToHostNode.convertLossy(value, targetType, interop)) != null) {
            return convertedValue;
        }
        if (targetType == Value.class && languageContext != null) {
            return value instanceof Value ? value : languageContext.asValue(value);
        }
        if (interop.isNull(value)) {
            if (targetType.isPrimitive()) {
                throw HostInteropErrors.nullCoercion(languageContext, value, targetType);
            }
            return null;
        }
        if (value instanceof TruffleObject && (convertedValue = ToHostNode.asJavaObject((TruffleObject)value, targetType, genericType, allowsImplementation, languageContext)) != null) {
            return convertedValue;
        }
        if (!targetType.isInstance(value)) {
            Object result2;
            if (useCustomTargetTypes && (result2 = targetMapping.execute(value, targetType, languageContext, interop, false, 3, 8)) != TargetMappingNode.NO_RESULT) {
                return result2;
            }
            error.enter();
            throw HostInteropErrors.cannotConvertPrimitive(languageContext, value, targetType);
        }
        convertedValue = value;
        return targetType.cast(convertedValue);
    }

    private static Object convertLossy(Object value, Class<?> targetType, InteropLibrary interop) {
        if ((targetType == Character.TYPE || targetType == Character.class) && interop.fitsInInt(value)) {
            try {
                int v = interop.asInt(value);
                if (v >= 0 && v < 65536) {
                    return Character.valueOf((char)v);
                }
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.shouldNotReachHere(e);
            }
        }
        return null;
    }

    static boolean canConvert(Object value, Class<?> targetType, Type genericType, Boolean allowsImplementation, PolyglotLanguageContext languageContext, int priority, InteropLibrary interop, TargetMappingNode targetMapping) {
        Object convertedValue;
        if (targetMapping != null && targetMapping.execute(value, targetType, languageContext, interop, true, 0, priority) == Boolean.TRUE) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        if (interop.isNull(value)) {
            return !targetType.isPrimitive();
        }
        if (targetType == Value.class && languageContext != null) {
            return true;
        }
        if (ToHostNode.isPrimitiveTarget(targetType) && (convertedValue = ToHostNode.convertLossLess(value, targetType, interop)) != null) {
            return true;
        }
        if (HostObject.isJavaInstance(targetType, value)) {
            return true;
        }
        if (priority <= 1) {
            return false;
        }
        if (targetType == Object.class) {
            return true;
        }
        if (targetType == List.class) {
            return interop.hasArrayElements(value);
        }
        if (targetType == Map.class) {
            return interop.hasMembers(value);
        }
        if (targetType == Function.class) {
            return interop.isExecutable(value) || interop.isInstantiable(value);
        }
        if (targetType == LocalDate.class) {
            return interop.isDate(value);
        }
        if (targetType == LocalTime.class) {
            return interop.isTime(value);
        }
        if (targetType == LocalDateTime.class) {
            return interop.isDate(value) && interop.isTime(value);
        }
        if (targetType == ZonedDateTime.class || targetType == Date.class || targetType == Instant.class) {
            return interop.isInstant(value);
        }
        if (targetType == ZoneId.class) {
            return interop.isTimeZone(value);
        }
        if (targetType == Duration.class) {
            return interop.isDuration(value);
        }
        if (targetType == PolyglotException.class) {
            return interop.isException(value);
        }
        if (priority <= 2) {
            return false;
        }
        if (targetType.isArray()) {
            return interop.hasArrayElements(value);
        }
        if (ToHostNode.isPrimitiveTarget(targetType) && (convertedValue = ToHostNode.convertLossy(value, targetType, interop)) != null) {
            return true;
        }
        if (value instanceof TruffleObject) {
            if (priority < 7 && HostObject.isInstance(value)) {
                return false;
            }
            if (priority >= 4 && HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value)) && ToHostNode.checkAllowsImplementation(targetType, allowsImplementation, languageContext)) {
                return true;
            }
            return (priority >= 5 && targetType.isInterface() || priority >= 6 && HostInteropReflect.isAbstractType(targetType)) && interop.hasMembers(value) && ToHostNode.checkAllowsImplementation(targetType, allowsImplementation, languageContext);
        }
        assert (!(value instanceof TruffleObject));
        return targetType.isInstance(value);
    }

    private static boolean checkAllowsImplementation(Class<?> targetType, Boolean allowsImplementation, PolyglotLanguageContext languageContext) {
        boolean implementations = allowsImplementation == null ? ToHostNode.allowsImplementation(languageContext, targetType) : allowsImplementation;
        return implementations;
    }

    static boolean isPrimitiveTarget(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Number.class || CharSequence.class.isAssignableFrom(clazz);
    }

    static Object convertToObject(Object value, PolyglotLanguageContext languageContext, InteropLibrary interop) {
        try {
            if (interop.isNull(value)) {
                return null;
            }
            if (interop.isString(value)) {
                return interop.asString(value);
            }
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isNumber(value)) {
                Object result = ToHostNode.convertToNumber(value, interop);
                if (result != null) {
                    return result;
                }
            } else {
                if (interop.hasMembers(value)) {
                    return ToHostNode.asJavaObject(value, Map.class, null, false, languageContext);
                }
                if (interop.hasArrayElements(value)) {
                    return ToHostNode.asJavaObject(value, List.class, null, false, languageContext);
                }
                if (interop.hasIterator(value)) {
                    return ToHostNode.asJavaObject(value, Iterable.class, null, false, languageContext);
                }
                if (interop.isIterator(value)) {
                    return ToHostNode.asJavaObject(value, Iterator.class, null, false, languageContext);
                }
                if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                    return ToHostNode.asJavaObject(value, Function.class, null, false, languageContext);
                }
            }
            return languageContext.asValue(value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    private static Object convertToNumber(Object value, InteropLibrary interop) {
        try {
            if (value instanceof Number) {
                return value;
            }
            if (interop.fitsInByte(value)) {
                return interop.asByte(value);
            }
            if (interop.fitsInShort(value)) {
                return interop.asShort(value);
            }
            if (interop.fitsInInt(value)) {
                return interop.asInt(value);
            }
            if (interop.fitsInLong(value)) {
                return interop.asLong(value);
            }
            if (interop.fitsInFloat(value)) {
                return Float.valueOf(interop.asFloat(value));
            }
            if (interop.fitsInDouble(value)) {
                return interop.asDouble(value);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaObject(Object value, Class<T> targetType, Type genericType, boolean allowsImplementation, PolyglotLanguageContext languageContext) {
        Object obj;
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(value);
        assert (!interop.isNull(value));
        if (HostObject.isJavaInstance(targetType, value)) {
            obj = HostObject.valueOf(value);
        } else if (targetType == Object.class) {
            obj = ToHostNode.convertToObject(value, languageContext, interop);
        } else if (targetType == List.class) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have array elements.");
            boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
            TypeAndClass<?> elementType = ToHostNode.getGenericParameterType(genericType, 0);
            obj = PolyglotList.create(languageContext, value, implementsFunction, elementType.clazz, elementType.type);
        } else if (targetType == Map.class) {
            boolean hasKeys;
            TypeAndClass<?> keyType = ToHostNode.getGenericParameterType(genericType, 0);
            TypeAndClass<?> valueType = ToHostNode.getGenericParameterType(genericType, 1);
            boolean hasHashEntries = interop.hasHashEntries(value);
            if (!hasHashEntries && !ToHostNode.isSupportedMapKeyType(keyType.clazz)) {
                throw ToHostNode.newInvalidKeyTypeException(keyType.clazz);
            }
            boolean hasSize = Number.class.isAssignableFrom(keyType.clazz) && interop.hasArrayElements(value);
            boolean bl = hasKeys = (keyType.clazz == Object.class || keyType.clazz == String.class) && interop.hasMembers(value);
            if (!hasKeys && !hasSize && !hasHashEntries) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have members, array elements or hash entries.");
            boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
            obj = PolyglotMap.create(languageContext, value, implementsFunction, keyType.clazz, keyType.type, valueType.clazz, valueType.type);
        } else if (targetType == Map.Entry.class) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have array elements.");
            TypeAndClass<?> keyType = ToHostNode.getGenericParameterType(genericType, 0);
            TypeAndClass<?> valueType = ToHostNode.getGenericParameterType(genericType, 1);
            boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
            obj = PolyglotMapEntry.create(languageContext, value, implementsFunction, keyType.clazz, keyType.type, valueType.clazz, valueType.type);
        } else if (targetType == Function.class) {
            TypeAndClass<?> returnType = ToHostNode.getGenericParameterType(genericType, 1);
            if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                obj = PolyglotFunction.create(languageContext, value, returnType.clazz, returnType.type);
            } else {
                if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must be executable or instantiable.");
                obj = HostInteropReflect.newProxyInstance(targetType, value, languageContext);
            }
        } else if (targetType.isArray()) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have array elements.");
            obj = ToHostNode.truffleObjectToArray(interop, value, targetType, genericType, languageContext);
        } else {
            if (targetType == LocalDate.class) {
                if (!interop.isDate(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asDate(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
            }
            if (targetType == LocalTime.class) {
                if (!interop.isTime(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
            }
            if (targetType == LocalDateTime.class) {
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date and time information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
                obj = ToHostNode.createDateTime(date, time);
            } else if (targetType == ZonedDateTime.class) {
                ZoneId timeZone;
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date, time and time-zone information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                    timeZone = interop.asTimeZone(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
                obj = ToHostNode.createZonedDateTime(date, time, timeZone);
            } else {
                if (targetType == ZoneId.class) {
                    if (!interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have time-zone information.");
                    try {
                        obj = interop.asTimeZone(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                }
                if (targetType == Instant.class || targetType == Date.class) {
                    Instant instantValue;
                    if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have date, time and time-zone information.");
                    try {
                        instantValue = interop.asInstant(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                    obj = targetType == Date.class ? Date.from(instantValue) : targetType.cast(instantValue);
                } else if (targetType == Duration.class) {
                    if (!interop.isDuration(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have duration information.");
                    try {
                        obj = interop.asDuration(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                } else if (targetType == PolyglotException.class) {
                    if (!interop.isException(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must be an exception.");
                    obj = ToHostNode.asPolyglotException(value, interop, languageContext);
                } else if (targetType == Iterable.class) {
                    if (interop.hasIterator(value)) {
                        boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
                        TypeAndClass<?> elementType = ToHostNode.getGenericParameterType(genericType, 0);
                        obj = PolyglotIterable.create(languageContext, value, implementsFunction, elementType.clazz, elementType.type);
                    } else {
                        if (!allowsImplementation || !interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have an iterator.");
                        obj = HostInteropReflect.newProxyInstance(targetType, value, languageContext);
                    }
                } else if (targetType == Iterator.class) {
                    if (interop.isIterator(value)) {
                        boolean implementsFunction = ToHostNode.shouldImplementFunction(value, interop);
                        TypeAndClass<?> elementType = ToHostNode.getGenericParameterType(genericType, 0);
                        obj = PolyglotIterator.create(languageContext, value, implementsFunction, elementType.clazz, elementType.type);
                    } else {
                        if (!allowsImplementation || !interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must be an iterator.");
                        obj = HostInteropReflect.newProxyInstance(targetType, value, languageContext);
                    }
                } else {
                    if (!allowsImplementation || !HostInteropReflect.isAbstractType(targetType)) return null;
                    if (HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value))) {
                        obj = HostInteropReflect.asJavaFunction(targetType, value, languageContext);
                    } else {
                        if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(languageContext, value, targetType, "Value must have members.");
                        obj = targetType.isInterface() ? HostInteropReflect.newProxyInstance(targetType, value, languageContext) : HostInteropReflect.newAdapterInstance(targetType, value, languageContext);
                    }
                }
            }
        }
        assert (targetType.isInstance(obj));
        return targetType.cast(obj);
    }

    private static Object asPolyglotException(Object value, InteropLibrary interop, PolyglotLanguageContext languageContext) {
        try {
            interop.throwException(value);
            throw UnsupportedMessageException.create();
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            return PolyglotImpl.guestToHostException(languageContext, e, true);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static ZonedDateTime createZonedDateTime(LocalDate date, LocalTime time, ZoneId timeZone) {
        return ZonedDateTime.of(date, time, timeZone);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalDateTime createDateTime(LocalDate date, LocalTime time) {
        return LocalDateTime.of(date, time);
    }

    private static boolean shouldImplementFunction(Object truffleObject, InteropLibrary interop) {
        boolean executable = interop.isExecutable(truffleObject);
        boolean instantiable = false;
        if (!executable) {
            instantiable = interop.isInstantiable(truffleObject);
        }
        boolean implementsFunction = executable || instantiable;
        return implementsFunction;
    }

    private static boolean isSupportedMapKeyType(Class<?> keyType) {
        return keyType == Object.class || keyType == String.class || keyType == Long.class || keyType == Integer.class || keyType == Number.class;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException newInvalidKeyTypeException(Type targetType) {
        String message = "Unsupported Map key type: " + targetType;
        return PolyglotEngineException.classCast(message);
    }

    private static TypeAndClass<?> getGenericParameterType(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (index < typeArguments.length) {
                Type elementType = typeArguments[index];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
                return new TypeAndClass(typeArguments[index], elementClass);
            }
        }
        return TypeAndClass.ANY;
    }

    private static Type getGenericArrayComponentType(Type genericType) {
        Type genericComponentType = null;
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            genericComponentType = genericArrayType.getGenericComponentType();
        }
        return genericComponentType;
    }

    private static Object truffleObjectToArray(InteropLibrary interop, Object receiver, Class<?> arrayType, Type genericArrayType, PolyglotLanguageContext languageContext) {
        long size;
        Class<?> componentType = arrayType.getComponentType();
        try {
            size = interop.getArraySize(receiver);
        }
        catch (UnsupportedMessageException e1) {
            assert (false) : "unexpected language behavior";
            size = 0L;
        }
        size = Math.min(size, Integer.MAX_VALUE);
        Object array = Array.newInstance(componentType, (int)size);
        Type genericComponentType = ToHostNode.getGenericArrayComponentType(genericArrayType);
        int i = 0;
        while ((long)i < size) {
            Object guestValue;
            try {
                guestValue = interop.readArrayElement(receiver, i);
            }
            catch (InvalidArrayIndexException e) {
                throw HostInteropErrors.invalidArrayIndex(languageContext, receiver, componentType, i);
            }
            catch (UnsupportedMessageException e) {
                throw HostInteropErrors.arrayReadUnsupported(languageContext, receiver, componentType);
            }
            Object hostValue = ToHostNodeGen.getUncached().execute(guestValue, componentType, genericComponentType, languageContext, true);
            Array.set(array, i, hostValue);
            ++i;
        }
        return array;
    }

    static final class TypeAndClass<T> {
        static final TypeAndClass<Object> ANY = new TypeAndClass<Object>(null, Object.class);
        final Type type;
        final Class<T> clazz;

        TypeAndClass(Type type, Class<T> clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public String toString() {
            return "[" + this.clazz + ": " + Objects.toString(this.type) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeAndClass)) {
                return false;
            }
            TypeAndClass other = (TypeAndClass)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.type, other.type);
        }
    }
}

