/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.CompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileRelationshipSheet
extends AbstractFileCompareSheet {
    static final int RELATIONSHIP_COL_WIDTH = 60;

    public FileRelationshipSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return fileA.arraysEquivalent(fileA.getRelationships(), fileB.getRelationships());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        return CompareHelper.relationshipsToString(spdxFile.getRelationships());
    }
}

