/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.FileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.model.SpdxDocument;

public class SPDXDocumentFactory {
    static final Logger logger = LoggerFactory.getLogger((String)SPDXDocumentFactory.class.getName());

    public static SpdxDocument createSpdxDocument(Model model) throws InvalidSPDXAnalysisException {
        SpdxDocumentContainer docContainer = new SpdxDocumentContainer(model);
        return docContainer.getSpdxDocument();
    }

    public static SPDXDocument createLegacySpdxDocument(Model model) throws InvalidSPDXAnalysisException {
        return new SPDXDocument(model);
    }

    public static SPDXDocument createLegacySpdxDocument(String fileNameOrUrl) throws IOException, InvalidSPDXAnalysisException {
        try {
            Class.forName("net.rootdev.javardfa.jena.RDFaReader");
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unable to load the RDFaReader Class");
        }
        InputStream spdxRdfInput = FileManager.get().open(fileNameOrUrl);
        if (spdxRdfInput == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameOrUrl + "\" for reading");
        }
        return SPDXDocumentFactory.createLegacySpdxDocument(spdxRdfInput, SPDXDocumentFactory.figureBaseUri(fileNameOrUrl), SPDXDocumentFactory.fileType(fileNameOrUrl));
    }

    public static SpdxDocument createSpdxDocument(String fileNameOrUrl) throws IOException, InvalidSPDXAnalysisException {
        try {
            Class.forName("net.rootdev.javardfa.jena.RDFaReader");
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unable to load the RDFaReader Class");
        }
        InputStream spdxRdfInput = FileManager.get().open(fileNameOrUrl);
        if (spdxRdfInput == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameOrUrl + "\" for reading");
        }
        return SPDXDocumentFactory.createSpdxDocument(spdxRdfInput, SPDXDocumentFactory.figureBaseUri(fileNameOrUrl), SPDXDocumentFactory.fileType(fileNameOrUrl));
    }

    public static SpdxDocument createSpdxDocument(InputStream input, String baseUri, String fileType) throws InvalidSPDXAnalysisException {
        Model model = ModelFactory.createDefaultModel();
        model.read(input, baseUri, fileType);
        SpdxDocumentContainer docContainer = new SpdxDocumentContainer(model);
        return docContainer.getSpdxDocument();
    }

    public static SPDXDocument createLegacySpdxDocument(InputStream input, String baseUri, String fileType) throws InvalidSPDXAnalysisException {
        Model model = ModelFactory.createDefaultModel();
        model.read(input, baseUri, fileType);
        return new SPDXDocument(model);
    }

    private static String figureBaseUri(String src) {
        URI s = null;
        try {
            s = new URI(src);
        }
        catch (URISyntaxException e) {
            s = null;
        }
        if (s == null || s.getScheme() == null) {
            String filePath = "///" + new File(src).getAbsoluteFile().toString().replace('\\', '/');
            try {
                s = new URI("file", filePath, null);
            }
            catch (URISyntaxException e1) {
                logger.error("Invalid URI syntax for " + src);
                return null;
            }
        }
        return s.toString();
    }

    private static String fileType(String path) {
        if (Pattern.matches("(?i:.*\\.x?html?$)", path)) {
            return "HTML";
        }
        return "RDF/XML";
    }
}

