/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginLoggerContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;

@Plugin(name="SpringProfile", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
final class SpringProfileArbiter
implements Arbiter {
    private final Environment environment;
    private final Profiles profiles;

    private SpringProfileArbiter(Environment environment, String[] profiles) {
        this.environment = environment;
        this.profiles = Profiles.of((String[])profiles);
    }

    public boolean isCondition() {
        return this.environment != null ? this.environment.acceptsProfiles(this.profiles) : false;
    }

    @PluginBuilderFactory
    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<SpringProfileArbiter> {
        private static final Logger statusLogger = StatusLogger.getLogger();
        @PluginBuilderAttribute
        private String name;
        @PluginConfiguration
        private Configuration configuration;
        @PluginLoggerContext
        private LoggerContext loggerContext;

        private Builder() {
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        public SpringProfileArbiter build() {
            Environment environment = Log4J2LoggingSystem.getEnvironment(this.loggerContext);
            if (environment == null) {
                statusLogger.debug("Creating Arbiter without a Spring Environment");
            }
            String name = this.configuration.getStrSubstitutor().replace(this.name);
            String[] profiles = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)name));
            return new SpringProfileArbiter(environment, profiles);
        }
    }
}

