/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.event;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.elasticsearch.core.event.ReactiveBeforeConvertCallback;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveAuditingEntityCallback
implements ReactiveBeforeConvertCallback<Object>,
Ordered {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public ReactiveAuditingEntityCallback(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Mono<Object> onBeforeConvert(Object entity, IndexCoordinates index) {
        return Mono.just((Object)((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity));
    }

    public int getOrder() {
        return 100;
    }
}

