/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsResponse;

public class ListDevEnvironmentsIterable
implements SdkIterable<ListDevEnvironmentsResponse> {
    private final CodeCatalystClient client;
    private final ListDevEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevEnvironmentsIterable(CodeCatalystClient client, ListDevEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevEnvironmentsResponseFetcher();
    }

    public Iterator<ListDevEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DevEnvironmentSummary> items() {
        Function<ListDevEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListDevEnvironmentsResponse> {
        private ListDevEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevEnvironmentsResponse nextPage(ListDevEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListDevEnvironmentsIterable.this.client.listDevEnvironments(ListDevEnvironmentsIterable.this.firstRequest);
            }
            return ListDevEnvironmentsIterable.this.client.listDevEnvironments((ListDevEnvironmentsRequest)((Object)ListDevEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

