/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystClient;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesItem;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse;

public class ListSourceRepositoriesIterable
implements SdkIterable<ListSourceRepositoriesResponse> {
    private final CodeCatalystClient client;
    private final ListSourceRepositoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSourceRepositoriesIterable(CodeCatalystClient client, ListSourceRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSourceRepositoriesResponseFetcher();
    }

    public Iterator<ListSourceRepositoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSourceRepositoriesItem> items() {
        Function<ListSourceRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSourceRepositoriesResponseFetcher
    implements SyncPageFetcher<ListSourceRepositoriesResponse> {
        private ListSourceRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSourceRepositoriesResponse nextPage(ListSourceRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListSourceRepositoriesIterable.this.client.listSourceRepositories(ListSourceRepositoriesIterable.this.firstRequest);
            }
            return ListSourceRepositoriesIterable.this.client.listSourceRepositories((ListSourceRepositoriesRequest)((Object)ListSourceRepositoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

