/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.EventBridgeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutCaseEventConfigurationRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, PutCaseEventConfigurationRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(PutCaseEventConfigurationRequest.getter(PutCaseEventConfigurationRequest::domainId)).setter(PutCaseEventConfigurationRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<EventBridgeConfiguration> EVENT_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventBridge").getter(PutCaseEventConfigurationRequest.getter(PutCaseEventConfigurationRequest::eventBridge)).setter(PutCaseEventConfigurationRequest.setter(Builder::eventBridge)).constructor(EventBridgeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, EVENT_BRIDGE_FIELD));
    private final String domainId;
    private final EventBridgeConfiguration eventBridge;

    private PutCaseEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.eventBridge = builder.eventBridge;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final EventBridgeConfiguration eventBridge() {
        return this.eventBridge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridge());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCaseEventConfigurationRequest)) {
            return false;
        }
        PutCaseEventConfigurationRequest other = (PutCaseEventConfigurationRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.eventBridge(), other.eventBridge());
    }

    public final String toString() {
        return ToString.builder((String)"PutCaseEventConfigurationRequest").add("DomainId", (Object)this.domainId()).add("EventBridge", (Object)this.eventBridge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "eventBridge": {
                return Optional.ofNullable(clazz.cast(this.eventBridge()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutCaseEventConfigurationRequest, T> g) {
        return obj -> g.apply((PutCaseEventConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private EventBridgeConfiguration eventBridge;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCaseEventConfigurationRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.eventBridge(model.eventBridge);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EventBridgeConfiguration.Builder getEventBridge() {
            return this.eventBridge != null ? this.eventBridge.toBuilder() : null;
        }

        public final void setEventBridge(EventBridgeConfiguration.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        @Override
        public final Builder eventBridge(EventBridgeConfiguration eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCaseEventConfigurationRequest build() {
            return new PutCaseEventConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutCaseEventConfigurationRequest> {
        public Builder domainId(String var1);

        public Builder eventBridge(EventBridgeConfiguration var1);

        default public Builder eventBridge(Consumer<EventBridgeConfiguration.Builder> eventBridge) {
            return this.eventBridge((EventBridgeConfiguration)((EventBridgeConfiguration.Builder)EventBridgeConfiguration.builder().applyMutation(eventBridge)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

