/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionModeValue {
    SSE_S3("sse-s3"),
    SSE_KMS("sse-kms"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionModeValue> VALUE_MAP;
    private final String value;

    private EncryptionModeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionModeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionModeValue> knownValues() {
        EnumSet<EncryptionModeValue> knownValues = EnumSet.allOf(EncryptionModeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionModeValue.class, EncryptionModeValue::toString);
    }
}

