/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;

public class DescribeCertificatesIterable
implements SdkIterable<DescribeCertificatesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCertificatesIterable(DatabaseMigrationClient client, DescribeCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCertificatesResponseFetcher();
    }

    public Iterator<DescribeCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeCertificatesResponseFetcher
    implements SyncPageFetcher<DescribeCertificatesResponse> {
        private DescribeCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCertificatesResponse nextPage(DescribeCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCertificatesIterable.this.client.describeCertificates(DescribeCertificatesIterable.this.firstRequest);
            }
            return DescribeCertificatesIterable.this.client.describeCertificates((DescribeCertificatesRequest)((Object)DescribeCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

