/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost;

public class GetCostEstimationIterable
implements SdkIterable<GetCostEstimationResponse> {
    private final DevOpsGuruClient client;
    private final GetCostEstimationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCostEstimationIterable(DevOpsGuruClient client, GetCostEstimationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCostEstimationResponseFetcher();
    }

    public Iterator<GetCostEstimationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceResourceCost> costs() {
        Function<GetCostEstimationResponse, Iterator> getIterator = response -> {
            if (response != null && response.costs() != null) {
                return response.costs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCostEstimationResponseFetcher
    implements SyncPageFetcher<GetCostEstimationResponse> {
        private GetCostEstimationResponseFetcher() {
        }

        public boolean hasNextPage(GetCostEstimationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCostEstimationResponse nextPage(GetCostEstimationResponse previousPage) {
            if (previousPage == null) {
                return GetCostEstimationIterable.this.client.getCostEstimation(GetCostEstimationIterable.this.firstRequest);
            }
            return GetCostEstimationIterable.this.client.getCostEstimation((GetCostEstimationRequest)((Object)GetCostEstimationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

