/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedAccessGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVerifiedAccessGroupsResponse> {
    private static final SdkField<List<VerifiedAccessGroup>> VERIFIED_ACCESS_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessGroups").getter(DescribeVerifiedAccessGroupsResponse.getter(DescribeVerifiedAccessGroupsResponse::verifiedAccessGroups)).setter(DescribeVerifiedAccessGroupsResponse.setter(Builder::verifiedAccessGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupSet").unmarshallLocationName("verifiedAccessGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedAccessGroupsResponse.getter(DescribeVerifiedAccessGroupsResponse::nextToken)).setter(DescribeVerifiedAccessGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<VerifiedAccessGroup> verifiedAccessGroups;
    private final String nextToken;

    private DescribeVerifiedAccessGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroups = builder.verifiedAccessGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVerifiedAccessGroups() {
        return this.verifiedAccessGroups != null && !(this.verifiedAccessGroups instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessGroup> verifiedAccessGroups() {
        return this.verifiedAccessGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessGroups() ? this.verifiedAccessGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessGroupsResponse)) {
            return false;
        }
        DescribeVerifiedAccessGroupsResponse other = (DescribeVerifiedAccessGroupsResponse)((Object)obj);
        return this.hasVerifiedAccessGroups() == other.hasVerifiedAccessGroups() && Objects.equals(this.verifiedAccessGroups(), other.verifiedAccessGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedAccessGroupsResponse").add("VerifiedAccessGroups", this.hasVerifiedAccessGroups() ? this.verifiedAccessGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessGroups": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessGroupsResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VerifiedAccessGroup> verifiedAccessGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessGroupsResponse model) {
            super(model);
            this.verifiedAccessGroups(model.verifiedAccessGroups);
            this.nextToken(model.nextToken);
        }

        public final List<VerifiedAccessGroup.Builder> getVerifiedAccessGroups() {
            List<VerifiedAccessGroup.Builder> result = VerifiedAccessGroupListCopier.copyToBuilder(this.verifiedAccessGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessGroups(Collection<VerifiedAccessGroup.BuilderImpl> verifiedAccessGroups) {
            this.verifiedAccessGroups = VerifiedAccessGroupListCopier.copyFromBuilder(verifiedAccessGroups);
        }

        @Override
        public final Builder verifiedAccessGroups(Collection<VerifiedAccessGroup> verifiedAccessGroups) {
            this.verifiedAccessGroups = VerifiedAccessGroupListCopier.copy(verifiedAccessGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessGroups(VerifiedAccessGroup ... verifiedAccessGroups) {
            this.verifiedAccessGroups(Arrays.asList(verifiedAccessGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessGroups(Consumer<VerifiedAccessGroup.Builder> ... verifiedAccessGroups) {
            this.verifiedAccessGroups(Stream.of(verifiedAccessGroups).map(c -> (VerifiedAccessGroup)((VerifiedAccessGroup.Builder)VerifiedAccessGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedAccessGroupsResponse build() {
            return new DescribeVerifiedAccessGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedAccessGroupsResponse> {
        public Builder verifiedAccessGroups(Collection<VerifiedAccessGroup> var1);

        public Builder verifiedAccessGroups(VerifiedAccessGroup ... var1);

        public Builder verifiedAccessGroups(Consumer<VerifiedAccessGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

