/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeSecurityGroupEgressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RevokeSecurityGroupEgressResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(RevokeSecurityGroupEgressResponse.getter(RevokeSecurityGroupEgressResponse::returnValue)).setter(RevokeSecurityGroupEgressResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<List<IpPermission>> UNKNOWN_IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnknownIpPermissions").getter(RevokeSecurityGroupEgressResponse.getter(RevokeSecurityGroupEgressResponse::unknownIpPermissions)).setter(RevokeSecurityGroupEgressResponse.setter(Builder::unknownIpPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownIpPermissionSet").unmarshallLocationName("unknownIpPermissionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, UNKNOWN_IP_PERMISSIONS_FIELD));
    private final Boolean returnValue;
    private final List<IpPermission> unknownIpPermissions;

    private RevokeSecurityGroupEgressResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.unknownIpPermissions = builder.unknownIpPermissions;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final boolean hasUnknownIpPermissions() {
        return this.unknownIpPermissions != null && !(this.unknownIpPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> unknownIpPermissions() {
        return this.unknownIpPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnknownIpPermissions() ? this.unknownIpPermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressResponse)) {
            return false;
        }
        RevokeSecurityGroupEgressResponse other = (RevokeSecurityGroupEgressResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && this.hasUnknownIpPermissions() == other.hasUnknownIpPermissions() && Objects.equals(this.unknownIpPermissions(), other.unknownIpPermissions());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeSecurityGroupEgressResponse").add("Return", (Object)this.returnValue()).add("UnknownIpPermissions", this.hasUnknownIpPermissions() ? this.unknownIpPermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "UnknownIpPermissions": {
                return Optional.ofNullable(clazz.cast(this.unknownIpPermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupEgressResponse, T> g) {
        return obj -> g.apply((RevokeSecurityGroupEgressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private List<IpPermission> unknownIpPermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.unknownIpPermissions(model.unknownIpPermissions);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<IpPermission.Builder> getUnknownIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.unknownIpPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnknownIpPermissions(Collection<IpPermission.BuilderImpl> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copyFromBuilder(unknownIpPermissions);
        }

        @Override
        public final Builder unknownIpPermissions(Collection<IpPermission> unknownIpPermissions) {
            this.unknownIpPermissions = IpPermissionListCopier.copy(unknownIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unknownIpPermissions(IpPermission ... unknownIpPermissions) {
            this.unknownIpPermissions(Arrays.asList(unknownIpPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unknownIpPermissions(Consumer<IpPermission.Builder> ... unknownIpPermissions) {
            this.unknownIpPermissions(Stream.of(unknownIpPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RevokeSecurityGroupEgressResponse build() {
            return new RevokeSecurityGroupEgressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeSecurityGroupEgressResponse> {
        public Builder returnValue(Boolean var1);

        public Builder unknownIpPermissions(Collection<IpPermission> var1);

        public Builder unknownIpPermissions(IpPermission ... var1);

        public Builder unknownIpPermissions(Consumer<IpPermission.Builder> ... var1);
    }
}

