/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamesparks.model.ResultCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentResult> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DeploymentResult.getter(DeploymentResult::message)).setter(DeploymentResult.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> RESULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultCode").getter(DeploymentResult.getter(DeploymentResult::resultCodeAsString)).setter(DeploymentResult.setter(Builder::resultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, RESULT_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String resultCode;

    private DeploymentResult(BuilderImpl builder) {
        this.message = builder.message;
        this.resultCode = builder.resultCode;
    }

    public final String message() {
        return this.message;
    }

    public final ResultCode resultCode() {
        return ResultCode.fromValue(this.resultCode);
    }

    public final String resultCodeAsString() {
        return this.resultCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentResult)) {
            return false;
        }
        DeploymentResult other = (DeploymentResult)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.resultCodeAsString(), other.resultCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentResult").add("Message", (Object)this.message()).add("ResultCode", (Object)this.resultCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ResultCode": {
                return Optional.ofNullable(clazz.cast(this.resultCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentResult, T> g) {
        return obj -> g.apply((DeploymentResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String resultCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentResult model) {
            this.message(model.message);
            this.resultCode(model.resultCode);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResultCode() {
            return this.resultCode;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(ResultCode resultCode) {
            this.resultCode(resultCode == null ? null : resultCode.toString());
            return this;
        }

        public DeploymentResult build() {
            return new DeploymentResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentResult> {
        public Builder message(String var1);

        public Builder resultCode(String var1);

        public Builder resultCode(ResultCode var1);
    }
}

