/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksClient;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.gamesparks.model.SnapshotSummary;

public class ListSnapshotsIterable
implements SdkIterable<ListSnapshotsResponse> {
    private final GameSparksClient client;
    private final ListSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSnapshotsIterable(GameSparksClient client, ListSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSnapshotsResponseFetcher();
    }

    public Iterator<ListSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotSummary> snapshots() {
        Function<ListSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSnapshotsResponseFetcher
    implements SyncPageFetcher<ListSnapshotsResponse> {
        private ListSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSnapshotsResponse nextPage(ListSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListSnapshotsIterable.this.client.listSnapshots(ListSnapshotsIterable.this.firstRequest);
            }
            return ListSnapshotsIterable.this.client.listSnapshots((ListSnapshotsRequest)((Object)ListSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

