/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2Client;
import software.amazon.awssdk.services.m2.model.DataSetImportTask;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetImportHistoryResponse;

public class ListDataSetImportHistoryIterable
implements SdkIterable<ListDataSetImportHistoryResponse> {
    private final M2Client client;
    private final ListDataSetImportHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSetImportHistoryIterable(M2Client client, ListDataSetImportHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataSetImportHistoryResponseFetcher();
    }

    public Iterator<ListDataSetImportHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSetImportTask> dataSetImportTasks() {
        Function<ListDataSetImportHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetImportTasks() != null) {
                return response.dataSetImportTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSetImportHistoryResponseFetcher
    implements SyncPageFetcher<ListDataSetImportHistoryResponse> {
        private ListDataSetImportHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetImportHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSetImportHistoryResponse nextPage(ListDataSetImportHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetImportHistoryIterable.this.client.listDataSetImportHistory(ListDataSetImportHistoryIterable.this.firstRequest);
            }
            return ListDataSetImportHistoryIterable.this.client.listDataSetImportHistory((ListDataSetImportHistoryRequest)((Object)ListDataSetImportHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

