/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppAttributesKeys {
    DOCUMENT_ROOT("DocumentRoot"),
    RAILS_ENV("RailsEnv"),
    AUTO_BUNDLE_ON_DEPLOY("AutoBundleOnDeploy"),
    AWS_FLOW_RUBY_SETTINGS("AwsFlowRubySettings"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppAttributesKeys> VALUE_MAP;
    private final String value;

    private AppAttributesKeys(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppAttributesKeys fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppAttributesKeys> knownValues() {
        EnumSet<AppAttributesKeys> knownValues = EnumSet.allOf(AppAttributesKeys.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppAttributesKeys.class, AppAttributesKeys::toString);
    }
}

