/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UploadBehavior {
    UPLOAD_ON_TERMINATE("UPLOAD_ON_TERMINATE"),
    UPLOAD_ROLLING_AUTO_REMOVE("UPLOAD_ROLLING_AUTO_REMOVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UploadBehavior> VALUE_MAP;
    private final String value;

    private UploadBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UploadBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UploadBehavior> knownValues() {
        EnumSet<UploadBehavior> knownValues = EnumSet.allOf(UploadBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UploadBehavior.class, UploadBehavior::toString);
    }
}

