/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoMLMetricEnum {
    ACCURACY("Accuracy"),
    MSE("MSE"),
    F1("F1"),
    F1_MACRO("F1macro"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoMLMetricEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLMetricEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoMLMetricEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLMetricEnum> knownValues() {
        return Stream.of(AutoMLMetricEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

