/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3Output;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingOutput> {
    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProcessingOutput.getter(ProcessingOutput::outputName)).setter(ProcessingOutput.setter(Builder::outputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputName").build()}).build();
    private static final SdkField<ProcessingS3Output> S3_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProcessingOutput.getter(ProcessingOutput::s3Output)).setter(ProcessingOutput.setter(Builder::s3Output)).constructor(ProcessingS3Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Output").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_NAME_FIELD, S3_OUTPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputName;
    private final ProcessingS3Output s3Output;

    private ProcessingOutput(BuilderImpl builder) {
        this.outputName = builder.outputName;
        this.s3Output = builder.s3Output;
    }

    public String outputName() {
        return this.outputName;
    }

    public ProcessingS3Output s3Output() {
        return this.s3Output;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Output());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingOutput)) {
            return false;
        }
        ProcessingOutput other = (ProcessingOutput)obj;
        return Objects.equals(this.outputName(), other.outputName()) && Objects.equals(this.s3Output(), other.s3Output());
    }

    public String toString() {
        return ToString.builder((String)"ProcessingOutput").add("OutputName", (Object)this.outputName()).add("S3Output", (Object)this.s3Output()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputName": {
                return Optional.ofNullable(clazz.cast(this.outputName()));
            }
            case "S3Output": {
                return Optional.ofNullable(clazz.cast(this.s3Output()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingOutput, T> g) {
        return obj -> g.apply((ProcessingOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputName;
        private ProcessingS3Output s3Output;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingOutput model) {
            this.outputName(model.outputName);
            this.s3Output(model.s3Output);
        }

        public final String getOutputName() {
            return this.outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        public final ProcessingS3Output.Builder getS3Output() {
            return this.s3Output != null ? this.s3Output.toBuilder() : null;
        }

        @Override
        public final Builder s3Output(ProcessingS3Output s3Output) {
            this.s3Output = s3Output;
            return this;
        }

        public final void setS3Output(ProcessingS3Output.BuilderImpl s3Output) {
            this.s3Output = s3Output != null ? s3Output.build() : null;
        }

        public ProcessingOutput build() {
            return new ProcessingOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingOutput> {
        public Builder outputName(String var1);

        public Builder s3Output(ProcessingS3Output var1);

        default public Builder s3Output(Consumer<ProcessingS3Output.Builder> s3Output) {
            return this.s3Output((ProcessingS3Output)((ProcessingS3Output.Builder)ProcessingS3Output.builder().applyMutation(s3Output)).build());
        }
    }
}

