/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.Parent;
import software.amazon.awssdk.services.sagemaker.model.ParentsCopier;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifactsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSource;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponent> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrialComponent.getter(TrialComponent::trialComponentName)).setter(TrialComponent.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrialComponent.getter(TrialComponent::displayName)).setter(TrialComponent.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TrialComponent.getter(TrialComponent::trialComponentArn)).setter(TrialComponent.setter(Builder::trialComponentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()}).build();
    private static final SdkField<TrialComponentSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponent.getter(TrialComponent::source)).setter(TrialComponent.setter(Builder::source)).constructor(TrialComponentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponent.getter(TrialComponent::status)).setter(TrialComponent.setter(Builder::status)).constructor(TrialComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrialComponent.getter(TrialComponent::startTime)).setter(TrialComponent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrialComponent.getter(TrialComponent::endTime)).setter(TrialComponent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrialComponent.getter(TrialComponent::creationTime)).setter(TrialComponent.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponent.getter(TrialComponent::createdBy)).setter(TrialComponent.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TrialComponent.getter(TrialComponent::lastModifiedTime)).setter(TrialComponent.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponent.getter(TrialComponent::lastModifiedBy)).setter(TrialComponent.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TrialComponent.getter(TrialComponent::parameters)).setter(TrialComponent.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TrialComponent.getter(TrialComponent::inputArtifacts)).setter(TrialComponent.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TrialComponent.getter(TrialComponent::outputArtifacts)).setter(TrialComponent.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<TrialComponentMetricSummary>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrialComponent.getter(TrialComponent::metrics)).setter(TrialComponent.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentMetricSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TrialComponentSourceDetail> SOURCE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TrialComponent.getter(TrialComponent::sourceDetail)).setter(TrialComponent.setter(Builder::sourceDetail)).constructor(TrialComponentSourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrialComponent.getter(TrialComponent::tags)).setter(TrialComponent.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Parent>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TrialComponent.getter(TrialComponent::parents)).setter(TrialComponent.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, DISPLAY_NAME_FIELD, TRIAL_COMPONENT_ARN_FIELD, SOURCE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, PARAMETERS_FIELD, INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, METRICS_FIELD, SOURCE_DETAIL_FIELD, TAGS_FIELD, PARENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trialComponentName;
    private final String displayName;
    private final String trialComponentArn;
    private final TrialComponentSource source;
    private final TrialComponentStatus status;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final Map<String, TrialComponentParameterValue> parameters;
    private final Map<String, TrialComponentArtifact> inputArtifacts;
    private final Map<String, TrialComponentArtifact> outputArtifacts;
    private final List<TrialComponentMetricSummary> metrics;
    private final TrialComponentSourceDetail sourceDetail;
    private final List<Tag> tags;
    private final List<Parent> parents;

    private TrialComponent(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.trialComponentArn = builder.trialComponentArn;
        this.source = builder.source;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metrics = builder.metrics;
        this.sourceDetail = builder.sourceDetail;
        this.tags = builder.tags;
        this.parents = builder.parents;
    }

    public String trialComponentName() {
        return this.trialComponentName;
    }

    public String displayName() {
        return this.displayName;
    }

    public String trialComponentArn() {
        return this.trialComponentArn;
    }

    public TrialComponentSource source() {
        return this.source;
    }

    public TrialComponentStatus status() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public UserContext createdBy() {
        return this.createdBy;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public Map<String, TrialComponentParameterValue> parameters() {
        return this.parameters;
    }

    public boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructMap);
    }

    public Map<String, TrialComponentArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructMap);
    }

    public Map<String, TrialComponentArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public List<TrialComponentMetricSummary> metrics() {
        return this.metrics;
    }

    public TrialComponentSourceDetail sourceDetail() {
        return this.sourceDetail;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructList);
    }

    public List<Parent> parents() {
        return this.parents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.parents());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponent)) {
            return false;
        }
        TrialComponent other = (TrialComponent)obj;
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.trialComponentArn(), other.trialComponentArn()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.sourceDetail(), other.sourceDetail()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.parents(), other.parents());
    }

    public String toString() {
        return ToString.builder((String)"TrialComponent").add("TrialComponentName", (Object)this.trialComponentName()).add("DisplayName", (Object)this.displayName()).add("TrialComponentArn", (Object)this.trialComponentArn()).add("Source", (Object)this.source()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Parameters", this.parameters()).add("InputArtifacts", this.inputArtifacts()).add("OutputArtifacts", this.outputArtifacts()).add("Metrics", this.metrics()).add("SourceDetail", (Object)this.sourceDetail()).add("Tags", this.tags()).add("Parents", this.parents()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "TrialComponentArn": {
                return Optional.ofNullable(clazz.cast(this.trialComponentArn()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "InputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "OutputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "SourceDetail": {
                return Optional.ofNullable(clazz.cast(this.sourceDetail()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponent, T> g) {
        return obj -> g.apply((TrialComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialComponentName;
        private String displayName;
        private String trialComponentArn;
        private TrialComponentSource source;
        private TrialComponentStatus status;
        private Instant startTime;
        private Instant endTime;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private List<TrialComponentMetricSummary> metrics = DefaultSdkAutoConstructList.getInstance();
        private TrialComponentSourceDetail sourceDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Parent> parents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponent model) {
            this.trialComponentName(model.trialComponentName);
            this.displayName(model.displayName);
            this.trialComponentArn(model.trialComponentArn);
            this.source(model.source);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.parameters(model.parameters);
            this.inputArtifacts(model.inputArtifacts);
            this.outputArtifacts(model.outputArtifacts);
            this.metrics(model.metrics);
            this.sourceDetail(model.sourceDetail);
            this.tags(model.tags);
            this.parents(model.parents);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getTrialComponentArn() {
            return this.trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        public final TrialComponentSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(TrialComponentSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(TrialComponentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            return this.parameters != null ? CollectionUtils.mapValues(this.parameters, TrialComponentParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            return this.inputArtifacts != null ? CollectionUtils.mapValues(this.inputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            return this.outputArtifacts != null ? CollectionUtils.mapValues(this.outputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        public final Collection<TrialComponentMetricSummary.Builder> getMetrics() {
            return this.metrics != null ? (Collection)this.metrics.stream().map(TrialComponentMetricSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metrics(Collection<TrialComponentMetricSummary> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TrialComponentMetricSummary ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TrialComponentMetricSummary.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (TrialComponentMetricSummary)((TrialComponentMetricSummary.Builder)TrialComponentMetricSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetrics(Collection<TrialComponentMetricSummary.BuilderImpl> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copyFromBuilder(metrics);
        }

        public final TrialComponentSourceDetail.Builder getSourceDetail() {
            return this.sourceDetail != null ? this.sourceDetail.toBuilder() : null;
        }

        @Override
        public final Builder sourceDetail(TrialComponentSourceDetail sourceDetail) {
            this.sourceDetail = sourceDetail;
            return this;
        }

        public final void setSourceDetail(TrialComponentSourceDetail.BuilderImpl sourceDetail) {
            this.sourceDetail = sourceDetail != null ? sourceDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<Parent.Builder> getParents() {
            return this.parents != null ? (Collection)this.parents.stream().map(Parent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<Parent.Builder> ... parents) {
            this.parents(Stream.of(parents).map(c -> (Parent)((Parent.Builder)Parent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        public TrialComponent build() {
            return new TrialComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponent> {
        public Builder trialComponentName(String var1);

        public Builder displayName(String var1);

        public Builder trialComponentArn(String var1);

        public Builder source(TrialComponentSource var1);

        default public Builder source(Consumer<TrialComponentSource.Builder> source) {
            return this.source((TrialComponentSource)((TrialComponentSource.Builder)TrialComponentSource.builder().applyMutation(source)).build());
        }

        public Builder status(TrialComponentStatus var1);

        default public Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return this.status((TrialComponentStatus)((TrialComponentStatus.Builder)TrialComponentStatus.builder().applyMutation(status)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder parameters(Map<String, TrialComponentParameterValue> var1);

        public Builder inputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder outputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder metrics(Collection<TrialComponentMetricSummary> var1);

        public Builder metrics(TrialComponentMetricSummary ... var1);

        public Builder metrics(Consumer<TrialComponentMetricSummary.Builder> ... var1);

        public Builder sourceDetail(TrialComponentSourceDetail var1);

        default public Builder sourceDetail(Consumer<TrialComponentSourceDetail.Builder> sourceDetail) {
            return this.sourceDetail((TrialComponentSourceDetail)((TrialComponentSourceDetail.Builder)TrialComponentSourceDetail.builder().applyMutation(sourceDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder parents(Collection<Parent> var1);

        public Builder parents(Parent ... var1);

        public Builder parents(Consumer<Parent.Builder> ... var1);
    }
}

