/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.LocalPortGenerater;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.ChannelType;
import cn.hutool.extra.ssh.Connector;
import cn.hutool.extra.ssh.JschRuntimeException;
import cn.hutool.extra.ssh.JschSessionPool;
import cn.hutool.extra.ssh.Sftp;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class JschUtil {
    public static final String SSH_NONE = "none";
    private static final LocalPortGenerater portGenerater = new LocalPortGenerater(10000);

    public static int generateLocalPort() {
        return portGenerater.generate();
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JschSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, sshPass);
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        return JschSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, privateKeyPath, passphrase);
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        Session session = JschUtil.createSession(sshHost, sshPort, sshUser, sshPass);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return session;
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Session session = JschUtil.createSession(sshHost, sshPort, sshUser, privateKeyPath, passphrase);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        JSch jsch = new JSch();
        Session session = JschUtil.createSession(jsch, sshHost, sshPort, sshUser);
        if (StrUtil.isNotEmpty(sshPass)) {
            session.setPassword(sshPass);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Assert.notEmpty(privateKeyPath, "PrivateKey Path must be not empty!", new Object[0]);
        JSch jsch = new JSch();
        try {
            jsch.addIdentity(privateKeyPath, passphrase);
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return JschUtil.createSession(jsch, sshHost, sshPort, sshUser);
    }

    public static Session createSession(JSch jsch, String sshHost, int sshPort, String sshUser) {
        Session session;
        Assert.notEmpty(sshHost, "SSH Host must be not empty!", new Object[0]);
        Assert.isTrue(sshPort > 0, "SSH port must be > 0", new Object[0]);
        if (StrUtil.isEmpty(sshUser)) {
            sshUser = "root";
        }
        if (null == jsch) {
            jsch = new JSch();
        }
        try {
            session = jsch.getSession(sshUser, sshHost, sshPort);
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws JschRuntimeException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new JschRuntimeException(e, "From [{}] mapping to [{}] error\uff01", remoteHost, localPort);
            }
            return true;
        }
        return false;
    }

    public static boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return true;
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws JschRuntimeException {
        Session session = JschUtil.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        int localPort = JschUtil.generateLocalPort();
        JschUtil.bindPort(session, remoteHost, remotePort, localPort);
        return localPort;
    }

    public static ChannelSftp openSftp(Session session) {
        return (ChannelSftp)JschUtil.openChannel(session, ChannelType.SFTP);
    }

    public static Sftp createSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        return new Sftp(sshHost, sshPort, sshUser, sshPass);
    }

    public static Sftp createSftp(Session session) {
        return new Sftp(session);
    }

    public static ChannelShell openShell(Session session) {
        return (ChannelShell)JschUtil.openChannel(session, ChannelType.SHELL);
    }

    public static Channel openChannel(Session session, ChannelType channelType) {
        Channel channel = JschUtil.createChannel(session, channelType);
        try {
            channel.connect();
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return channel;
    }

    public static Channel createChannel(Session session, ChannelType channelType) {
        Channel channel;
        try {
            if (!session.isConnected()) {
                session.connect();
            }
            channel = session.openChannel(channelType.getValue());
        }
        catch (JSchException e) {
            throw new JschRuntimeException(e);
        }
        return channel;
    }

    public static String exec(Session session, String cmd, Charset charset) {
        return JschUtil.exec(session, cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exec(Session session, String cmd, Charset charset, OutputStream errStream) {
        String string;
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        ChannelExec channel = (ChannelExec)JschUtil.createChannel(session, ChannelType.EXEC);
        channel.setCommand(StrUtil.bytes((CharSequence)cmd, charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.connect();
            in = channel.getInputStream();
            string = IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
                catch (JSchException e2) {
                    throw new JschRuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                JschUtil.close((Channel)channel);
                throw throwable;
            }
        }
        IoUtil.close(in);
        JschUtil.close((Channel)channel);
        return string;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        JschSessionPool.INSTANCE.remove(session);
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }

    public static void close(String key) {
        JschSessionPool.INSTANCE.close(key);
    }

    public static void closeAll() {
        JschSessionPool.INSTANCE.closeAll();
    }
}

